/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.infrastructure.node.network;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.infrastructure.node.Node;
import com.gamedash.daemon.infrastructure.node.network.Data;
import com.google.gson.JsonObject;
import java.net.Inet4Address;

public class Network {
    private Node node;
    private Data data;

    public Network(Node node) {
        this.node = node;
    }

    public boolean isSecure() throws Exception {
        return this.getData().isSecure;
    }

    public Inet4Address getIp() throws Exception {
        return this.getData().ip;
    }

    public int getPort() throws Exception {
        return this.getData().port;
    }

    private Data getData() throws Exception {
        if (this.data == null) {
            ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/" + this.node.getId());
            JsonObject result = query.get().getJsonObject().get("response").getAsJsonObject();
            Data data = new Data();
            data.isSecure = result.get("isSecure").getAsBoolean();
            data.ip = (Inet4Address)Inet4Address.getByName(result.get("ip").getAsString());
            data.port = result.get("port").getAsInt();
            this.data = data;
        }
        return this.data;
    }
}

