/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.remote.user;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.api.client.response.QueryResponse;
import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.fileSystem.remote.user.CachedRemoteFileSystemUser;
import com.gamedash.daemon.fileSystem.remote.user.RemoteFileSystemUser;
import com.gamedash.daemon.fileSystem.remote.user.RemoteFileSystemUserException;
import com.gamedash.daemon.fileSystem.remote.user.RemoteFileSystemUserNotFoundException;
import com.gamedash.daemon.system.user.SystemUsers;
import com.google.gson.JsonElement;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;

public class RemoteFileSystemUsers {
    private static CopyOnWriteArrayList<CachedRemoteFileSystemUser> cachedUsers = new CopyOnWriteArrayList();
    private static final int userCacheTimeout = 60;

    public static synchronized RemoteFileSystemUser get(String name) throws Exception {
        String systemUserId;
        for (CachedRemoteFileSystemUser user : cachedUsers) {
            if (!user.getName().equals(name)) continue;
            if (60L > Time.now().getTimestamp() - user.getTimeCached().getTimestamp()) {
                return user;
            }
            cachedUsers.remove(user);
        }
        ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/filesystem/remote/user/" + name);
        query.setShouldHandleResponse(false);
        QueryResponse queryResponse = query.get();
        if (queryResponse.getStatusCode() != 200) {
            if (queryResponse.getStatusCode() == 404) {
                throw new RemoteFileSystemUserNotFoundException("User " + name + " not found");
            }
            throw new RemoteFileSystemUserException(queryResponse.getJsonObject().get("error").getAsJsonObject().get("status").getAsString());
        }
        JsonElement response = queryResponse.getJsonObject().get("response");
        CachedRemoteFileSystemUser user = new CachedRemoteFileSystemUser(name);
        user.getFiles().setRootDirectory(new File(response.getAsJsonObject().get("files").getAsJsonObject().get("rootDirectory").getAsJsonObject().get("path").getAsString()));
        JsonElement allocationSizeJsonElement = response.getAsJsonObject().get("files").getAsJsonObject().get("allocationSize");
        if (!allocationSizeJsonElement.isJsonNull()) {
            user.getFiles().setAllocationSize(allocationSizeJsonElement.getAsLong());
        }
        ArrayList<String> blacklistedExtensions = new ArrayList<String>();
        for (JsonElement element : response.getAsJsonObject().get("file").getAsJsonObject().get("extension").getAsJsonObject().get("blacklisted").getAsJsonArray()) {
            blacklistedExtensions.add(element.getAsString());
        }
        user.getFiles().getExtensions().setBlacklisted(blacklistedExtensions);
        String string = systemUserId = !response.getAsJsonObject().get("node").getAsJsonObject().get("user").getAsJsonObject().get("id").isJsonNull() ? response.getAsJsonObject().get("node").getAsJsonObject().get("user").getAsJsonObject().get("id").getAsString() : null;
        if (systemUserId != null) {
            user.setSystemUser(SystemUsers.get(systemUserId));
        }
        cachedUsers.add(user);
        return user;
    }

    public static boolean exists(String name) throws Exception {
        ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/filesystem/ftp/user/" + name + "/exists");
        return query.get().getJsonObject().get("response").getAsBoolean();
    }
}

