/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.system.user.fileSystem.file;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import com.gamedash.daemon.system.user.SystemUser;
import com.gamedash.daemon.system.user.SystemUserNotFoundException;
import com.gamedash.daemon.system.user.SystemUsers;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class AssignPermissions
extends Route<String> {
    public AssignPermissions(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        String name = this.request.getInput().getParameters().get("name").getValue();
        if (!SystemUsers.exists(name)) {
            throw new SystemUserNotFoundException("User " + name + " does not exist");
        }
        for (File file : this.getFiles()) {
            SystemUser systemUser = SystemUsers.get(this.request.getInput().getParameters().get("name").getValue());
            systemUser.assignFileSystemFilePermission(file);
        }
        return null;
    }

    private List<File> getFiles() {
        return this.request.getInput().getParameters().get("paths").getList().stream().map(FileUtils::fromBase64).collect(Collectors.toList());
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"name", "paths"};
    }
}

