/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process.childprocess;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.io.listener.FilterListener;
import com.gamedash.daemon.process.childProcess.io.listener.RelayListener;
import com.gamedash.daemon.process.childProcess.reference.References;
import com.gamedash.daemon.process.childProcess.terminal.generic.Generic;
import com.gamedash.daemon.process.childProcess.terminal.pty.Pty;
import com.gamedash.daemon.process.childProcess.terminal.windows.Windows;
import com.gamedash.daemon.relay.client.channel.Channel;
import com.gamedash.daemon.relay.client.channel.Channels;
import com.gamedash.daemon.system.user.SystemUser;
import com.gamedash.daemon.system.user.SystemUsers;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Create
extends Route<Object> {
    private static Logger logger = LoggerFactory.getLogger(Create.class);

    public Create(Request request, com.gamedash.daemon.api.server.response.Response response) {
        super(request, response);
    }

    @Override
    public Response execute() throws Exception {
        String executable = this.request.getInput().getParameters().get("executable").getValue();
        List<String> args = this.request.getInput().getParameters().get("args").getList();
        Boolean await = this.request.getInput().getParameters().exists("await") ? this.request.getInput().getParameters().get("await").getValue(Boolean.class) : Boolean.valueOf(false);
        File workingDirectory = this.getWorkingDirectory();
        String referenceName = this.request.getInput().getParameters().exists("reference") ? this.request.getInput().getParameters().get("reference").getValue() : null;
        ArrayList<String> outputFilters = this.request.getInput().getParameters().exists("outputFilters") ? this.request.getInput().getParameters().get("outputFilters").getList() : new ArrayList<String>();
        Map<String, String> environmentVariables = this.getEnvironmentVariables();
        Boolean useShell = this.request.getInput().getParameters().exists("useShell") ? this.request.getInput().getParameters().get("useShell").getValue(Boolean.class) : null;
        String systemUserName = this.request.getInput().getParameters().exists("systemUserName") ? this.request.getInput().getParameters().get("systemUserName").getValue(String.class) : null;
        String systemUserPassword = this.request.getInput().getParameters().exists("systemUserPassword") ? this.request.getInput().getParameters().get("systemUserPassword").getValue(String.class) : null;
        Boolean isSelfManaged = this.request.getInput().getParameters().exists("isSelfManaged") ? this.request.getInput().getParameters().get("isSelfManaged").getValue(Boolean.class) : null;
        ChildProcess process = ChildProcesses.create(this.getTerminalClass());
        if (isSelfManaged != null || await.booleanValue()) {
            if (await.booleanValue()) {
                process.setIsSelfManaged(false);
            } else {
                process.setIsSelfManaged(isSelfManaged);
            }
        }
        if (referenceName != null) {
            process.getReferences();
            if (References.exists(referenceName)) {
                throw new Exception("Reference with name " + referenceName + " already exists");
            }
            process.getReferences().create(referenceName);
        }
        if (!await.booleanValue()) {
            process.setShouldReportCrashes(true);
        }
        if (workingDirectory != null) {
            process.setWorkingDirectory(workingDirectory);
        }
        if (environmentVariables != null) {
            process.setEnvironmentVariables(environmentVariables);
        }
        if (useShell != null) {
            process.setUseShell(useShell);
        }
        if (systemUserName != null) {
            SystemUser systemUser = SystemUsers.get(systemUserName);
            if (systemUserPassword != null) {
                systemUser.setStoredPassword(systemUserPassword);
            }
            process.setSystemUser(systemUser);
        }
        process.onExit(() -> logger.debug("Process " + process.getId() + " exited"));
        List<Channel> relayChannels = this.getRelayChannels();
        if (relayChannels != null) {
            process.getIo().addListener(new RelayListener(process, relayChannels));
        }
        if (outputFilters != null) {
            process.getIo().addListener(new FilterListener(process, outputFilters));
        }
        process.spawn(executable, args.toArray(new String[0]));
        if (await.booleanValue()) {
            AwaitedResponse response = new AwaitedResponse(process.getId());
            process.waitForExit();
            response.exitCode = process.getExitCode();
            process.getIo().getOutputItems().forEach(outputItem -> response.addOutputItem(new ResponseOutputItem((OutputItem)outputItem)));
            process.delete();
            return response;
        }
        return new Response(process.getId());
    }

    private Map<String, String> getEnvironmentVariables() throws Exception {
        String jsonString;
        String string = jsonString = this.request.getInput().getParameters().exists("environmentVariables") ? this.request.getInput().getParameters().get("environmentVariables").getValue() : null;
        if (jsonString != null) {
            Gson gson = new Gson();
            return gson.fromJson(jsonString, Map.class);
        }
        return null;
    }

    private File getWorkingDirectory() throws Exception {
        return this.request.getInput().getParameters().exists("workingDirectory") ? new File(this.request.getInput().getParameters().get("workingDirectory").getValue()) : null;
    }

    private Class<?> getTerminalClass() throws Exception {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Windows.class;
        }
        if (this.request.getInput().getParameters().exists("terminal") && this.request.getInput().getParameters().get("terminal").getValue().equalsIgnoreCase("pty")) {
            return Pty.class;
        }
        return Generic.class;
    }

    private List<Channel> getRelayChannels() {
        if (!this.request.getInput().getParameters().exists("relayChannels")) {
            return null;
        }
        return this.request.getInput().getParameters().get("relayChannels").getList().stream().map(Channels::get).collect(Collectors.toList());
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"executable", "args"};
    }

    private static class ResponseOutputItem {
        @SerializedName(value="index")
        private final long index;
        @SerializedName(value="isError")
        private final boolean isError;
        @SerializedName(value="value")
        private final String value;
        @SerializedName(value="timestampCreated")
        private final long timestampCreated;

        public ResponseOutputItem(OutputItem outputItem) {
            this.index = outputItem.getIndex();
            this.isError = outputItem.isError();
            this.value = outputItem.getValue();
            this.timestampCreated = outputItem.getTimeCreated().getTimestamp();
        }
    }

    private static class AwaitedResponse
    extends Response {
        @SerializedName(value="exitCode")
        public int exitCode;
        @SerializedName(value="output")
        private final List<ResponseOutputItem> outputItems = new ArrayList<ResponseOutputItem>();

        public AwaitedResponse(int id) {
            super(id);
        }

        void addOutputItem(ResponseOutputItem outputItem) {
            this.outputItems.add(outputItem);
        }
    }

    private static class Response {
        @SerializedName(value="id")
        protected long id;

        public Response(int id) {
            this.id = id;
        }
    }
}

