/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.network.port;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.network.port.Port;
import com.gamedash.daemon.network.port.Ports;
import com.gamedash.daemon.network.port.ProtocolsEnum;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.Processes;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class GetAll
extends Route<List<?>> {
    public GetAll(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<ResponsePort> execute() throws Exception {
        ArrayList<ResponsePort> ports = new ArrayList<ResponsePort>();
        for (Port port : Ports.getOpen()) {
            if (!Processes.exists(port.getProcess().getId())) continue;
            ports.add(new ResponsePort(port));
        }
        return ports;
    }

    private static class ResponsePort {
        @SerializedName(value="number")
        private int number;
        private ProtocolsEnum protocol;
        @SerializedName(value="process")
        private ResponsePortProcess process;

        public ResponsePort(Port port) throws Exception {
            this.number = port.getNumber();
            this.protocol = port.getProtocol();
            IProcess portProcess = port.getProcess();
            if (portProcess != null) {
                this.process = new ResponsePortProcess(portProcess);
            }
        }

        private static class ResponsePortProcess {
            @SerializedName(value="id")
            private long id;
            @SerializedName(value="name")
            private String name;

            public ResponsePortProcess(IProcess process) throws Exception {
                this.id = process.getId();
                this.name = process.getName();
            }
        }
    }
}

