/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.network.port;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.network.port.Port;
import com.gamedash.daemon.network.port.PortDoesNotExistException;
import com.gamedash.daemon.network.port.Ports;
import com.gamedash.daemon.process.IProcess;
import com.google.gson.annotations.SerializedName;

public class Get
extends Route<Object> {
    private Integer number;

    public Get(Request request, com.gamedash.daemon.api.server.response.Response response) throws Exception {
        super(request, response);
        this.number = Integer.parseInt(this.request.getInput().getParameters().get("number").getValue());
    }

    @Override
    public Response execute() throws Exception {
        if (!Ports.isOpen(this.number)) {
            throw new PortDoesNotExistException("Port " + this.number + " does not exist");
        }
        return new Response(Ports.get(this.number));
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"number"};
    }

    private static class Response {
        @SerializedName(value="process")
        private ResponseProcess process;

        public Response(Port port) throws Exception {
            this.process = new ResponseProcess(port.getProcess());
        }

        private static class ResponseProcess {
            @SerializedName(value="id")
            private int id;
            @SerializedName(value="name")
            private String name;

            public ResponseProcess(IProcess process) throws Exception {
                this.id = process.getId();
                this.name = process.getName();
            }
        }
    }
}

