/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.api.server.route.routes.fileSystem.FileSystemSystemUserTrait;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import com.gamedash.daemon.fileSystem.file.upload.session.Session;
import com.gamedash.daemon.fileSystem.file.upload.session.Sessions;
import com.gamedash.daemon.system.user.SystemUser;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class CreateSession
extends Route<String>
implements FileSystemSystemUserTrait {
    public CreateSession(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File destination = FileUtils.fromBase64(this.request.getInput().getParameters().get("destination").getValue());
        int chunkCount = this.request.getInput().getParameters().get("chunkCount").getValue(Integer.class);
        if (destination.exists() && destination.isDirectory()) {
            throw new IOException("Destination path already exists, however it is a directory");
        }
        Session session = Sessions.create(this.getId(), destination, chunkCount);
        SystemUser systemUser = this.getSystemUser(this.request, "systemUserName");
        if (systemUser != null) {
            session.setSystemUser(systemUser);
        }
        if (this.request.getInput().getParameters().exists("chunkSize")) {
            session.setChunkSize(this.request.getInput().getParameters().get("chunkSize").getValue(Long.class));
        }
        return session.getId().toString();
    }

    private UUID getId() throws Exception {
        if (this.request.getInput().getParameters().exists("id")) {
            return UUID.fromString(this.request.getInput().getParameters().get("id").getValue());
        }
        return UUID.randomUUID();
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"destination", "chunkCount"};
    }
}

