/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.group;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Exists
extends Route<Object> {
    public Exists(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<OutputResult> execute() throws Exception {
        List<String> filePaths = this.request.getInput().getParameters().get("files").getList();
        ArrayList<OutputResult> outputResults = new ArrayList<OutputResult>();
        for (String filePath : filePaths) {
            File file = FileUtils.fromBase64(filePath);
            outputResults.add(new OutputResult(file, file.exists()));
        }
        return outputResults;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"files"};
    }

    private static class OutputResult {
        @SerializedName(value="path")
        private final String path;
        @SerializedName(value="exists")
        private final boolean exists;

        public OutputResult(File file, boolean exists) {
            this.path = file.getPath();
            this.exists = exists;
        }
    }
}

