/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server;

import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.api.server.ApiServerException;
import com.gamedash.daemon.api.server.ErrorBody;
import com.google.gson.Gson;

public class ExceptionHandler<T extends Exception> {
    private Class<T> type;
    private int httpStatusCode = 400;
    private String code;
    private Gson gson = new Gson();
    private ApiServer server;

    public ExceptionHandler(Class<T> type) {
        this.type = type;
    }

    public ExceptionHandler(ApiServer server, Class<T> type, int httpStatusCode) {
        this.server = server;
        this.type = type;
        this.httpStatusCode = httpStatusCode;
    }

    public ExceptionHandler(ApiServer server, Class<T> type, int httpStatusCode, String code) {
        this.server = server;
        this.type = type;
        this.httpStatusCode = httpStatusCode;
        this.code = code;
    }

    public void register() {
        this.server.getService().exception(this.type, (exception, request, response) -> {
            response.status(this.getHttpStatusCode());
            response.type("application/json");
            ErrorBody errorBody = new ErrorBody(exception.getMessage(), exception.getStackTrace());
            if (exception instanceof ApiServerException && ((ApiServerException)exception).hasCode()) {
                errorBody.setCode(((ApiServerException)exception).getCode());
            }
            response.body(this.gson.toJson(errorBody));
        });
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getCode() {
        return this.code;
    }
}

