/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon;

import com.beust.jcommander.JCommander;
import com.gamedash.daemon.Args;
import com.gamedash.daemon.Init;
import com.gamedash.daemon.build.Build;
import com.gamedash.daemon.common.authentication.Authentication;
import com.gamedash.daemon.common.authentication.AuthenticationToken;
import com.gamedash.daemon.common.fileSystem.FileSystem;
import com.gamedash.daemon.common.installer.InstallerStateEnum;
import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.common.version.Versions;
import com.gamedash.daemon.infrastructure.node.Nodes;
import com.gamedash.daemon.installer.Installer;
import com.gamedash.daemon.permission.Permissions;
import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.shutdown.Shutdown;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    public static Args args = new Args();
    public static Time initTime = Time.now();
    public static final Logger logger = LoggerFactory.getLogger(Application.class);

    public void run(String[] argv) {
        JCommander.newBuilder().addObject(args).build().parse(argv);
        if (Application.args.debug.booleanValue()) {
            ConsoleAppender consoleAppender = (ConsoleAppender)LogManager.getRootLogger().getAppender("STDOUT");
            consoleAppender.setThreshold(Level.DEBUG);
        }
        try {
            Init.initConfig();
            Init.initFileSystem();
            if (SystemUtils.IS_OS_WINDOWS && !WindowsBridge.isInstalled()) {
                Init.initWindows();
            }
            if (!Application.isRunningWithRequiredPermissions()) {
                throw new RuntimeException("Running with elevated permissions is required");
            }
            Init.initDependencies();
            Init.initNetwork();
            if (Application.args.installOnly.booleanValue() || Installer.getState() == InstallerStateEnum.notInstalled || Installer.getState() == InstallerStateEnum.inProgress) {
                if (!Permissions.isRunningWithElevatedPermissions()) {
                    throw new RuntimeException("Installation required elevated permissions");
                }
                Installer.install();
                if (Application.args.installOnly.booleanValue()) {
                    System.exit(0);
                }
            }
            if (Application.args.shouldUninstall.booleanValue()) {
                if (Installer.getState() != InstallerStateEnum.installed) {
                    throw new Exception("Daemon is not currently installed");
                }
                Installer.uninstall();
                System.exit(0);
            }
            Init.initApiClient();
            Init.initKeyStore();
            Shutdown.registerHook();
            Init.initServices();
            Nodes.getSelf().getStatus().update(true);
            logger.info("Initialisation complete");
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
            System.exit(1);
        }
    }

    public void shutdown() throws Exception {
        Shutdown.run();
    }

    public static boolean isRunningWithRequiredPermissions() throws Exception {
        if (SystemUtils.IS_OS_LINUX) {
            return System.getProperty("user.name").equals("root");
        }
        return true;
    }

    public static void setRootDirectory(File directory) {
        FileSystem.setRootDirectory(directory);
    }

    public static void setVersion(Integer id) throws Exception {
        Build.setVersion(Versions.get(id));
    }

    public static void setAuthenticationToken(String token) throws IOException {
        logger.info("Received new authentication token " + token);
        Authentication.setCurrentToken(new AuthenticationToken(token));
    }
}

