/*
 * Decompiled with CFR 0.152.
 */
package com.schokkerit.restapi.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.schokkerit.restapi.client.ApiQueryException;
import com.schokkerit.restapi.client.enums.HttpProtocolsEnum;
import com.schokkerit.restapi.client.input.header.Header;
import com.schokkerit.restapi.client.input.header.Headers;
import com.schokkerit.restapi.client.input.parameter.Parameter;
import com.schokkerit.restapi.client.input.parameter.Parameters;
import com.schokkerit.restapi.client.response.IQueryResponse;
import com.schokkerit.restapi.client.response.QueryResponse;
import com.schokkerit.restapi.client.response.QueryResponseErrorHandlerManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiQuery {
    private static final Logger logger = LoggerFactory.getLogger(ApiQuery.class);
    private String endpoint;
    private Headers headers = new Headers();
    private Parameters parameters = new Parameters();
    private boolean hasExecuted = false;
    private boolean shouldHandleResponse = true;
    protected QueryResponseErrorHandlerManager responseErrorHandlerManager = new QueryResponseErrorHandlerManager(this);
    protected CloseableHttpClient httpClient = this.createClient();

    public ApiQuery(String endpoint) throws Exception {
        this.endpoint = endpoint;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public IQueryResponse delete() throws Exception {
        URIBuilder builder = new URIBuilder(this.getAddress());
        for (Parameter<?> parameter : this.getParameters().getAll()) {
            builder.addParameter(parameter.getName(), parameter.toString());
        }
        return this.makeRequest(new HttpDelete(builder.build()));
    }

    public IQueryResponse put() throws Exception {
        HttpPut httpPut = new HttpPut(this.getAddress());
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        for (Parameter<?> parameter : this.getParameters().getAll()) {
            parameters.add(new BasicNameValuePair(parameter.getName(), parameter.toString()));
        }
        httpPut.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)parameters));
        return this.makeRequest(httpPut);
    }

    public IQueryResponse post() throws Exception {
        HttpPost httpPost = new HttpPost(this.getAddress());
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        for (Parameter<?> parameter : this.getParameters().getAll()) {
            parameters.add(new BasicNameValuePair(parameter.getName(), parameter.toString()));
        }
        httpPost.setEntity(new UrlEncodedFormEntity(parameters, "UTF-8"));
        return this.makeRequest(httpPost);
    }

    public IQueryResponse get() throws Exception {
        URIBuilder builder = new URIBuilder(this.getAddress());
        for (Parameter<?> parameter : this.getParameters().getAll()) {
            builder.addParameter(parameter.getName(), parameter.toString());
        }
        return this.makeRequest(new HttpGet(builder.build()));
    }

    public boolean shouldHandleResponse() {
        return this.shouldHandleResponse;
    }

    public void setShouldHandleResponse(boolean shouldHandleResponse) {
        this.shouldHandleResponse = shouldHandleResponse;
    }

    public QueryResponseErrorHandlerManager getResponseErrorHandlerManager() {
        return this.responseErrorHandlerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQueryResponse makeRequest(HttpRequestBase httpMethod) throws Exception {
        if (this.hasExecuted) {
            throw new ApiQueryException("API query has already been executed");
        }
        logger.debug("Requesting " + httpMethod.getMethod() + " " + this.getAddress());
        try {
            for (Header<?> header : this.getHeaders().getAll()) {
                httpMethod.addHeader(header.getName(), header.toString());
            }
            IQueryResponse iQueryResponse = this.httpClient.execute((HttpUriRequest)httpMethod, response -> {
                int statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                String rawResponse = EntityUtils.toString(entity);
                JsonObject jsonObject = !rawResponse.equals("") ? new JsonParser().parse(rawResponse).getAsJsonObject() : null;
                QueryResponse queryResponse = new QueryResponse(jsonObject, statusCode);
                if (this.shouldHandleResponse() && queryResponse.isError()) {
                    this.getResponseErrorHandlerManager().handleIncoming(queryResponse);
                }
                return queryResponse;
            });
            return iQueryResponse;
        }
        finally {
            this.httpClient.close();
            this.hasExecuted = true;
        }
    }

    protected String getEndpoint() {
        return this.endpoint;
    }

    protected abstract String getAddress() throws Exception;

    protected HttpProtocolsEnum getProtocol() throws Exception {
        return this.isSecure() != false ? HttpProtocolsEnum.https : HttpProtocolsEnum.http;
    }

    protected abstract Boolean isSecure() throws Exception;

    protected CloseableHttpClient createClient() throws Exception {
        return HttpClients.createDefault();
    }
}

