/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.system.user;

import com.gamedash.daemon.system.user.ISystemUsers;
import com.gamedash.daemon.system.user.SystemUser;
import com.gamedash.daemon.system.user.SystemUserException;
import com.gamedash.daemon.system.user.platform.linux.LinuxSystemUsers;
import com.gamedash.daemon.system.user.platform.windows.WindowsSystemUsers;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.SystemUtils;

public class SystemUsers {
    public static SystemUser get(String name) {
        return new SystemUser(name, SystemUsers.getApi().get(name));
    }

    public static boolean exists(String name) throws Exception {
        return SystemUsers.getApi().exists(name);
    }

    public static SystemUser create(String name, String password) throws Exception {
        try {
            if (SystemUsers.exists(name)) {
                throw new SystemUserException("System user " + name + " already exists");
            }
            SystemUsers.getApi().create(name, password);
            return SystemUsers.get(name);
        }
        catch (InvocationTargetException e) {
            throw new Exception(e.getCause());
        }
    }

    private static ISystemUsers getApi() {
        return SystemUtils.IS_OS_LINUX ? new LinuxSystemUsers() : new WindowsSystemUsers();
    }
}

