/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.shutdown;

import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.common.development.DevelopmentMode;
import com.gamedash.daemon.common.installer.InstallerStateEnum;
import com.gamedash.daemon.fileSystem.remote.host.RemoteFileSystemHost;
import com.gamedash.daemon.fileSystem.remote.host.RemoteFileSystemHosts;
import com.gamedash.daemon.infrastructure.node.Nodes;
import com.gamedash.daemon.installer.Installer;
import com.gamedash.daemon.platform.linux.cgroup.LinuxCGroup;
import com.gamedash.daemon.platform.linux.cgroup.LinuxCGroups;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcessNotRunningException;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shutdown {
    private static Logger logger = LoggerFactory.getLogger(Shutdown.class);
    private static boolean isShuttingDown = false;

    public static void registerHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            block2: {
                logger.info("Shutting down");
                try {
                    Shutdown.run();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                    if (!DevelopmentMode.isEnabled()) break block2;
                    logger.error(e.getMessage());
                }
            }
        }));
    }

    public static void run() throws Exception {
        if (Shutdown.isShuttingDown()) {
            return;
        }
        Shutdown.setIsShuttingDown(true);
        if (Installer.getState() == InstallerStateEnum.inProgress) {
            Installer.setState(InstallerStateEnum.notInstalled);
        }
        Shutdown.cleanUpChildProcesses();
        ExecutorService threadPool = Executors.newCachedThreadPool();
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        if (SystemUtils.IS_OS_LINUX) {
            futures.add(threadPool.submit(Shutdown::cleanUpLinuxCGroups));
        }
        futures.add(threadPool.submit(Shutdown::cleanUpApiServer));
        futures.add(threadPool.submit(Shutdown::cleanupRemoteFileSystemHosts));
        futures.add(threadPool.submit(Shutdown::updateNodeStatus));
        threadPool.shutdown();
        threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        for (Future future : futures) {
            future.get();
        }
    }

    private static Void cleanUpApiServer() {
        for (ApiServer server : ApiServer.getInstances()) {
            if (!server.isRunning().booleanValue()) continue;
            server.stop();
        }
        return null;
    }

    private static Void cleanupRemoteFileSystemHosts() throws Exception {
        for (RemoteFileSystemHost host : RemoteFileSystemHosts.getAll()) {
            if (!host.isRunning()) continue;
            host.stop();
        }
        return null;
    }

    private static Void cleanUpChildProcesses() throws Exception {
        List<ChildProcess> running = ChildProcesses.getRunning();
        if (running.size() > 0) {
            ArrayList<ChildProcess> processesToAwaitExit = new ArrayList<ChildProcess>();
            for (ChildProcess childProcess : running) {
                try {
                    if (childProcess.canInterrupt()) {
                        childProcess.stop();
                        continue;
                    }
                    processesToAwaitExit.add(childProcess);
                }
                catch (ChildProcessNotRunningException childProcessNotRunningException) {
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                }
            }
            for (ChildProcess childProcess : processesToAwaitExit) {
                childProcess.waitForExit();
            }
        }
        return null;
    }

    private static Void cleanUpLinuxCGroups() throws Exception {
        if (LinuxCGroups.getAll().size() > 0) {
            for (LinuxCGroup cGroup : LinuxCGroups.getAll()) {
                cGroup.delete();
            }
        }
        return null;
    }

    private static Void updateNodeStatus() throws Exception {
        Nodes.getSelf().getStatus().update(false);
        return null;
    }

    public static boolean isShuttingDown() {
        return isShuttingDown;
    }

    private static void setIsShuttingDown(boolean isShuttingDown) {
        Shutdown.isShuttingDown = isShuttingDown;
    }
}

