/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.client.channel;

import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.relay.Message;
import com.gamedash.daemon.relay.host.Host;
import com.gamedash.daemon.relay.host.Hosts;
import com.google.gson.Gson;

public class Channel {
    private String name;

    public Channel(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void broadcast(Message<?> message) throws Exception {
        final Host host = Hosts.getPrimary();
        ApiQuery query = new ApiQuery("broadcast"){

            @Override
            protected String getAddress() throws Exception {
                return this.getProtocol() + "://" + host.getNetwork().getDomain() + ":" + host.getNetwork().getApiPort() + "/" + this.getEndpoint();
            }

            @Override
            protected Boolean isSecure() {
                return host.getNetwork().apiIsSecure();
            }
        };
        query.getParameters().create("channel", this.getName()).setValue(this.getName());
        query.getParameters().create("type", message.getType()).setValue(message.getType());
        query.getParameters().create("message", new Gson().toJson(message.getMessage()));
        query.post();
    }
}

