/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.platform.windows;

import com.gamedash.daemon.platform.windows.process.WindowsBridgeProcess;
import com.gamedash.daemon.platform.windows.process.WindowsBridgeProcessException;
import com.gamedash.daemon.platform.windows.process.WindowsBridgeProcesses;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.platform.windows.WindowsProcess;
import java.util.ArrayList;
import java.util.List;

public class WindowsProcesses {
    public static List<WindowsProcess> getAll() throws Exception {
        ArrayList<WindowsProcess> processes = new ArrayList<WindowsProcess>();
        for (WindowsBridgeProcess windowsBridgeProcess : WindowsBridgeProcesses.getAll()) {
            processes.add(new WindowsProcess(windowsBridgeProcess));
        }
        return processes;
    }

    public static WindowsProcess get(int id) throws WindowsBridgeProcessException {
        return new WindowsProcess(WindowsBridgeProcesses.get(id));
    }

    public static boolean exists(int id) throws Exception {
        return WindowsBridgeProcesses.exists(id);
    }

    public static void stop(WindowsProcess[] processes) throws Exception {
        for (WindowsProcess process : processes) {
            process.stop();
        }
    }

    public static void kill(WindowsProcess[] processes) throws Exception {
        for (WindowsProcess process : processes) {
            process.kill();
        }
    }

    public static WindowsProcess[] filter(IProcess[] processes) {
        ArrayList<WindowsProcess> filtered = new ArrayList<WindowsProcess>();
        for (IProcess process : processes) {
            if (!(process instanceof WindowsProcess)) continue;
            filtered.add((WindowsProcess)process);
        }
        return (WindowsProcess[])filtered.toArray(WindowsProcess[]::new);
    }
}

