/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.process.childProcess;

import com.gamedash.daemon.platform.windows.IWindowsBridge;
import com.gamedash.daemon.platform.windows.WindowsBridge;
import com.gamedash.daemon.platform.windows.WindowsBridgeException;
import com.gamedash.daemon.platform.windows.process.WindowsBridgeProcess;
import com.gamedash.daemon.platform.windows.process.WindowsBridgeProcesses;
import com.gamedash.daemon.platform.windows.process.childProcess.IWindowsBridgeChildProcessOnExitCallback;
import com.gamedash.daemon.platform.windows.process.childProcess.WindowsBridgeChildProcessException;
import com.gamedash.daemon.platform.windows.process.childProcess.WindowsBridgeChildProcessUser;
import com.gamedash.daemon.platform.windows.process.childProcess.WindowsBridgeChildProcesses;
import com.gamedash.daemon.platform.windows.process.childProcess.io.Io;
import com.gamedash.daemon.platform.windows.result.WindowsBridgeResult;
import com.gamedash.daemon.platform.windows.result.WindowsBridgeResults;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsBridgeChildProcess {
    private static Logger logger = LoggerFactory.getLogger(WindowsBridgeChildProcess.class);
    private Integer id;
    private Io io = new Io(this);
    private WindowsBridgeChildProcessUser user;
    private IWindowsBridge.IChildProcessOnExitCallback onExitListenerCallback;
    private List<IWindowsBridgeChildProcessOnExitCallback> onExitCallbacks = new ArrayList<IWindowsBridgeChildProcessOnExitCallback>();
    private File workingDirectory = new File("C:\\");
    private boolean isListeningForExit = false;
    private boolean hasExited = false;

    public int getId() {
        return this.id;
    }

    private void setId(int id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spawn(String executable, String[] args) throws Exception {
        WindowsBridgeChildProcessUser user = this.getUser();
        WindowsBridgeResult result = user != null && user.getSystemUser().hasStoredPassword() ? WindowsBridgeResults.get(WindowsBridge.getInstance().spawnChildProcessAsUser(executable, String.join((CharSequence)" ", args), this.getWorkingDirectory().getPath(), user.getSystemUser().getName(), user.getSystemUser().getStoredPassword())) : WindowsBridgeResults.get(WindowsBridge.getInstance().spawnChildProcess(executable, String.join((CharSequence)" ", args), this.getWorkingDirectory().getPath()));
        try {
            if (result.isError()) {
                throw new WindowsBridgeChildProcessException(result.getErrorMessage());
            }
            this.setId(result.getResultValueAsInteger());
            this.onExit(() -> this.getIo().destroy());
            new Thread(() -> {
                try {
                    this.getIo().listen();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                }
            }).start();
            new Thread(() -> {
                try {
                    this.listenForExit();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                }
            }).start();
        }
        finally {
            result.delete();
        }
    }

    public void stop() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().stopChildProcess(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsBridgeChildProcessException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    public void kill() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().killChildProcess(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsBridgeChildProcessException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    public int getExitCode() {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getChildProcessExitCode(this.getId()));
        return result.getResultValueAsInteger();
    }

    public void delete() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().deleteChildProcess(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsBridgeChildProcessException(result.getErrorMessage());
            }
            WindowsBridgeChildProcesses.getAll().remove(this);
        }
        finally {
            result.delete();
        }
    }

    public Io getIo() {
        return this.io;
    }

    public void waitForExit() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.onExit(latch::countDown);
        latch.await();
    }

    public void sendInput(String input) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().childProcessSendInput(this.getId(), input));
        try {
            if (result.isError()) {
                throw new WindowsBridgeException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    public void onExit(IWindowsBridgeChildProcessOnExitCallback callback) {
        this.onExitCallbacks.add(callback);
    }

    public boolean hasExited() {
        return this.hasExited;
    }

    private void setHasExited(boolean hasExited) {
        this.hasExited = hasExited;
    }

    private void listenForExit() throws Exception {
        if (this.isListeningForExit) {
            throw new WindowsBridgeChildProcessException("Already listening for exit");
        }
        this.isListeningForExit = true;
        CountDownLatch latch = new CountDownLatch(1);
        this.onExitListenerCallback = () -> {
            this.setHasExited(true);
            this.onExitCallbacks.forEach(IWindowsBridgeChildProcessOnExitCallback::method);
            latch.countDown();
        };
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().onChildProcessExit(this.getId(), this.onExitListenerCallback));
        if (result.isError()) {
            throw new WindowsBridgeChildProcessException(result.getErrorMessage());
        }
        latch.await();
        WindowsBridge.getInstance().removeChildProcessOnExitCallback(this.getId(), this.id);
    }

    public List<WindowsBridgeProcess> getChildren() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getChildProcessChildren(this.id));
        if (result.isError()) {
            throw new WindowsBridgeChildProcessException(result.getErrorMessage());
        }
        ArrayList<WindowsBridgeProcess> processes = new ArrayList<WindowsBridgeProcess>();
        for (String id : result.getResultValueAsList()) {
            processes.add(WindowsBridgeProcesses.get(Integer.parseInt(id)));
        }
        return processes;
    }

    public WindowsBridgeChildProcessUser getUser() {
        return this.user;
    }

    public void setUser(WindowsBridgeChildProcessUser user) {
        this.user = user;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File directory) {
        this.workingDirectory = directory;
    }
}

