/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.process;

import com.gamedash.daemon.platform.windows.WindowsBridge;
import com.gamedash.daemon.platform.windows.process.WindowsBridgeProcess;
import com.gamedash.daemon.platform.windows.process.WindowsBridgeProcessException;
import com.gamedash.daemon.platform.windows.result.WindowsBridgeResult;
import com.gamedash.daemon.platform.windows.result.WindowsBridgeResults;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WindowsBridgeProcesses {
    public static List<WindowsBridgeProcess> getAll() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getAllProcesses());
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        ArrayList<WindowsBridgeProcess> processes = new ArrayList<WindowsBridgeProcess>();
        for (JsonElement jsonElement : result.getResultValueAsJson().getAsJsonArray()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            WindowsBridgeProcess process = new WindowsBridgeProcess(jsonObject.get("id").getAsInt());
            process.name = jsonObject.get("name").getAsString();
            process.fileName = jsonObject.get("fileName").getAsString();
            ArrayList<String> argumentsList = new ArrayList<String>();
            for (JsonElement argumentJsonArrayElement : jsonObject.get("arguments").getAsJsonArray()) {
                argumentsList.add(argumentJsonArrayElement.getAsString());
            }
            process.arguments = argumentsList.toArray(new String[0]);
            process.workingDirectory = new File(jsonObject.get("workingDirectory").getAsString());
            processes.add(process);
        }
        return processes;
    }

    public static WindowsBridgeProcess get(int id) throws WindowsBridgeProcessException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcess(id));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        JsonObject jsonObject = result.getResultValueAsJson().getAsJsonObject();
        WindowsBridgeProcess process = new WindowsBridgeProcess(id);
        process.name = jsonObject.get("name").getAsString();
        process.fileName = jsonObject.get("fileName").getAsString();
        ArrayList<String> argumentsList = new ArrayList<String>();
        for (JsonElement argumentJsonArrayElement : jsonObject.get("arguments").getAsJsonArray()) {
            argumentsList.add(argumentJsonArrayElement.getAsString());
        }
        process.arguments = argumentsList.toArray(new String[0]);
        process.workingDirectory = new File(jsonObject.get("workingDirectory").getAsString());
        return process;
    }

    public static boolean exists(int id) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().processExists(id));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsBoolean();
    }
}

