/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.process;

import com.gamedash.daemon.platform.windows.WindowsBridge;
import com.gamedash.daemon.platform.windows.process.WindowsBridgeProcessException;
import com.gamedash.daemon.platform.windows.process.WindowsBridgeProcesses;
import com.gamedash.daemon.platform.windows.process.WindowsBridgeResourceProcessUsage;
import com.gamedash.daemon.platform.windows.process.priority.WindowsBridgeProcessPriorityEnum;
import com.gamedash.daemon.platform.windows.result.WindowsBridgeResult;
import com.gamedash.daemon.platform.windows.result.WindowsBridgeResults;
import com.gamedash.daemon.system.hardware.processor.Processor;
import com.gamedash.daemon.system.hardware.processor.Processors;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WindowsBridgeProcess {
    private int id;
    private WindowsBridgeResourceProcessUsage usage;
    public String name;
    public String fileName;
    public String[] arguments;
    public File workingDirectory;

    public WindowsBridgeProcess(int id) {
        this.id = id;
        this.usage = new WindowsBridgeResourceProcessUsage(this);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void kill() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().killProcess(this.getId()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
    }

    public List<WindowsBridgeProcess> getChildren() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessChildren(this.getId()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        ArrayList<WindowsBridgeProcess> processes = new ArrayList<WindowsBridgeProcess>();
        for (String id : result.getResultValueAsList()) {
            processes.add(WindowsBridgeProcesses.get(Integer.parseInt(id)));
        }
        return processes;
    }

    public void setProcessorAffinity(List<Processor> processors) throws Exception {
        this.setProcessorAffinity(Processors.toMask(processors));
    }

    public void setProcessorAffinity(long mask) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().setProcessProcessorAffinity(this.getId(), mask));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
    }

    public WindowsBridgeProcessPriorityEnum getPriority() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessPriority(this.getId()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        int integer = result.getResultValueAsInteger();
        for (WindowsBridgeProcessPriorityEnum priority : WindowsBridgeProcessPriorityEnum.values()) {
            if (priority.getInteger() != integer) continue;
            return priority;
        }
        return null;
    }

    public void setPriority(WindowsBridgeProcessPriorityEnum priority) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().setProcessPriority(this.getId(), priority.getInteger()));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
    }

    public WindowsBridgeResourceProcessUsage getResourceUsage() {
        return this.usage;
    }
}

