/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.cgroup.resource;

import com.gamedash.daemon.platform.linux.cgroup.LinuxCGroup;
import com.gamedash.daemon.platform.linux.cgroup.LinuxCGroupException;
import com.gamedash.daemon.platform.linux.cgroup.controller.DiskController;
import com.gamedash.daemon.platform.linux.cgroup.resource.AbstractResource;
import com.gamedash.daemon.platform.linux.cgroup.resource.IResource;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;

public class DiskResource
extends AbstractResource
implements IResource {
    private LinuxCGroup cGroup;
    private int mbs;

    public DiskResource(LinuxCGroup cGroup) {
        super(cGroup, new DiskController());
        this.cGroup = cGroup;
    }

    public int getMBs() {
        return this.mbs;
    }

    public void setMBs(int mbs) throws Exception {
        this.mbs = mbs;
    }

    @Override
    public void limitProcess(IProcess process) throws Exception {
        super.limitProcess(process);
        this.pushThrottle();
        if (!this.cGroup.getProcess(process.getId()).resourceIsLimited(this)) {
            this.cGroup.getProcess(process.getId()).addLimitedResource(this);
        }
    }

    private void pushThrottle() throws Exception {
        ChildProcess process = ChildProcesses.create();
        process.setCanInterrupt(false);
        process.spawn("cgset -r blkio.throttle.read_bps_device=\"252:0 " + this.mbs + "\" " + this.cGroup.getName());
        process.waitForExit();
        if (process.getExitCode() != 0) {
            throw new LinuxCGroupException("Could not set disk throttle");
        }
    }
}

