/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.network.port;

import com.gamedash.daemon.network.port.Port;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.childProcess.terminal.io.OutputItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;

public class Ports {
    private static final List<Port> ports = new ArrayList<Port>();

    public static List<Port> getAll() throws Exception {
        ArrayList<Port> ports = new ArrayList<Port>();
        if (SystemUtils.IS_OS_LINUX) {
            ChildProcess process = ChildProcesses.create();
            process.setCanInterrupt(false);
            process.spawn("netstat", new String[]{"-tunlp"});
            process.waitForExit();
            for (OutputItem item : process.getIo().getOutputItems()) {
                String[] columns;
                if (item.isError() || item.getValue().equals("") || (columns = item.getValue().split("\\s+"))[3].split(":").length < 2) continue;
                Port port = Ports.get(Integer.parseInt(columns[3].split(":")[columns[3].split(":").length - 1]));
                int processId = Integer.parseInt(columns.length == 8 || columns.length == 7 ? columns[6].split("/")[0] : columns[5].split("/")[0]);
                port.setProcess(Processes.get(processId));
                ports.add(port);
            }
        }
        return ports;
    }

    public static Port get(int number) {
        for (Port port : ports) {
            if (port.getNumber() != number) continue;
            return port;
        }
        Port port = new Port(number);
        ports.add(port);
        return port;
    }

    public static boolean exists(int number) throws Exception {
        for (Port port : Ports.getAll()) {
            if (port.getNumber() != number) continue;
            return true;
        }
        return false;
    }
}

