/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.network.port;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.childProcess.terminal.io.OutputItem;
import org.apache.commons.lang3.SystemUtils;

public class Port {
    private int number;
    private IProcess process;

    public Port(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public IProcess getProcess() throws Exception {
        if (this.process != null) {
            return this.process;
        }
        Integer id = this.getProcessId();
        if (id == null) {
            return null;
        }
        return Processes.get(id);
    }

    public void setProcess(IProcess process) {
        this.process = process;
    }

    private Integer getProcessId() throws Exception {
        ChildProcess process = ChildProcesses.create();
        if (SystemUtils.IS_OS_LINUX) {
            process.spawn("netstat", new String[]{"-tunlp"});
            process.waitForExit();
            for (OutputItem item : process.getIo().getOutputItems()) {
                String[] columns;
                if (item.isError() || item.getValue().equals("") || (columns = item.getValue().split("\\s+"))[3].split(":").length < 2 || Integer.parseInt(columns[3].split(":")[columns[3].split(":").length - 1]) != this.getNumber()) continue;
                return Integer.parseInt(columns.length == 6 ? columns[5].split("/")[0] : columns[4].split("/")[0]);
            }
        }
        return null;
    }
}

