/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.file.upload.session.chunk;

import com.gamedash.daemon.fileSystem.file.upload.session.Session;
import com.gamedash.daemon.fileSystem.file.upload.session.chunk.Chunk;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.IOUtils;

public class Chunks {
    private Session session;
    private List<Chunk> chunks = new CopyOnWriteArrayList<Chunk>();

    public Chunks(Session session) {
        this.session = session;
    }

    public List<Chunk> getAll() {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        int i = 1;
        while ((long)i < this.session.getChunkCount() + 1L) {
            chunks.add(this.get(i));
            ++i;
        }
        return chunks;
    }

    public Chunk get(long id) {
        for (Chunk chunk : this.chunks) {
            if (chunk.getId() != id) continue;
            return chunk;
        }
        Chunk chunk = new Chunk(this.session, id);
        this.chunks.add(chunk);
        return chunk;
    }

    public boolean exists(long id) {
        for (Chunk chunk : this.getAll()) {
            if (chunk.getId() != id) continue;
            return true;
        }
        return false;
    }

    public boolean hasReceivedAll() {
        if ((long)this.getAll().size() != this.session.getChunkCount()) {
            return false;
        }
        for (Chunk chunk : this.getAll()) {
            if (chunk.hasReceived()) continue;
            return false;
        }
        return true;
    }

    public void merge() throws Exception {
        if (!this.hasReceivedAll()) {
            throw new Exception("Did not receive all chunks yet");
        }
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(this.session.getDestination()));){
            List<Chunk> sortedChunks = this.getAll();
            sortedChunks.sort((a, b) -> b.getId() > a.getId() ? -1 : 1);
            for (Chunk chunk : sortedChunks) {
                BufferedInputStream inputStream = chunk.getStream();
                try {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    ((InputStream)inputStream).close();
                }
            }
        }
        if (this.session.getSystemUser() != null) {
            this.session.getSystemUser().assignFileSystemFilePermission(this.session.getDestination());
        }
    }

    public void cleanup() throws IOException {
        for (Chunk chunk : this.getAll()) {
            chunk.cleanup();
        }
    }
}

