/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency.dependencies;

import com.gamedash.daemon.dependency.DependencyAnnotation;
import com.gamedash.daemon.dependency.IDependency;
import com.gamedash.daemon.dependency.install.IInstallerManagerProgressCallback;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloader;
import com.gamedash.daemon.platform.windows.WindowsBridge;
import com.gamedash.daemon.system.OperatingSystem;
import com.gamedash.daemon.system.OperatingSystemArchitectureEnum;
import java.io.File;
import java.net.URL;
import org.apache.commons.lang3.SystemUtils;

@DependencyAnnotation(name="WindowsBridge64")
public class WindowsBridgeDependency64
implements IDependency {
    @Override
    public void install(IInstallerManagerProgressCallback callback) throws Exception {
        FileDownloader fileDownloader = new FileDownloader(this.getFile(), new URL("https://download.gamedash.io/daemon/dependency/versions/1/WindowsBridge-x64.dll"));
        fileDownloader.download();
    }

    @Override
    public void uninstall(IInstallerManagerProgressCallback callback) {
        this.getFile().delete();
    }

    @Override
    public boolean isAvailable() {
        return SystemUtils.IS_OS_WINDOWS && OperatingSystem.getArchitecture() == OperatingSystemArchitectureEnum.x64;
    }

    private File getFile() {
        return WindowsBridge.getDllFile();
    }
}

