/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency.dependencies;

import com.gamedash.daemon.dependency.DependencyAnnotation;
import com.gamedash.daemon.dependency.IDependency;
import com.gamedash.daemon.dependency.install.IInstallerManagerProgressCallback;
import com.gamedash.daemon.platform.linux.LinuxDistroEnum;
import com.gamedash.daemon.platform.linux.LinuxPlatform;
import com.gamedash.daemon.platform.linux.LinuxPlatformRelease;
import com.gamedash.daemon.platform.linux.packages.LinuxPackages;
import org.apache.commons.lang3.SystemUtils;

@DependencyAnnotation(name="LinuxCGroups")
public class LinuxCGroupDependency
implements IDependency {
    @Override
    public void install(IInstallerManagerProgressCallback callback) throws Exception {
        LinuxPlatformRelease linuxDistro = LinuxPlatform.getRelease();
        if (linuxDistro.getDistro() == LinuxDistroEnum.centos || linuxDistro.getDistro() == LinuxDistroEnum.rhel) {
            LinuxPackages.get("libcgroup").install();
        } else if (linuxDistro.getDistro() == LinuxDistroEnum.ubuntu || linuxDistro.getDistro() == LinuxDistroEnum.debian) {
            LinuxPackages.get("cgroup-tools").install();
        }
    }

    @Override
    public void uninstall(IInstallerManagerProgressCallback callback) throws Exception {
        LinuxPlatformRelease linuxDistro = LinuxPlatform.getRelease();
        if (linuxDistro.getDistro() == LinuxDistroEnum.centos || linuxDistro.getDistro() == LinuxDistroEnum.rhel) {
            LinuxPackages.get("libcgroup").uninstall();
        } else if (linuxDistro.getDistro() == LinuxDistroEnum.ubuntu || linuxDistro.getDistro() == LinuxDistroEnum.debian) {
            LinuxPackages.get("cgroup-tools").uninstall();
        }
    }

    @Override
    public boolean isAvailable() {
        return SystemUtils.IS_OS_LINUX;
    }
}

