/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency;

import com.gamedash.daemon.dependency.Dependencies;
import com.gamedash.daemon.dependency.DependencyAnnotation;
import com.gamedash.daemon.dependency.IDependency;
import com.gamedash.daemon.dependency.install.InstallManager;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dependency {
    private static Logger logger = LoggerFactory.getLogger(Dependency.class);
    private Class<? extends IDependency> dependencyClass;
    private IDependency instance;
    private InstallManager installManager;

    public Dependency(Class<? extends IDependency> dependencyClass) {
        this.dependencyClass = dependencyClass;
    }

    public String getName() {
        DependencyAnnotation annotation = this.getAnnotation();
        return annotation != null ? annotation.name() : null;
    }

    public boolean isInstalled() throws Exception {
        for (Dependency dependency : Dependencies.getInstalled()) {
            if (!dependency.getName().equals(this.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isAvailable() throws Exception {
        return this.getInstance().isAvailable();
    }

    public Class<? extends IDependency> getDependencyClass() {
        return this.dependencyClass;
    }

    private DependencyAnnotation getAnnotation() {
        for (Annotation annotation : this.getDependencyClass().getAnnotations()) {
            if (!(annotation instanceof DependencyAnnotation)) continue;
            return (DependencyAnnotation)annotation;
        }
        return null;
    }

    public InstallManager getInstallManager() {
        if (this.installManager == null) {
            this.installManager = new InstallManager(this);
        }
        return this.installManager;
    }

    public IDependency getInstance() throws Exception {
        if (this.instance == null) {
            this.instance = this.dependencyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return this.instance;
    }
}

