/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.system;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import oshi.SystemInfo;
import oshi.hardware.HWDiskStore;

public class GetInfo
extends Route {
    private SystemInfo systemInfo = new SystemInfo();

    public GetInfo(Request request, Response response) {
        super(request, response);
    }

    public Info execute() throws Exception {
        Info info = new Info();
        info.cpu.name = this.systemInfo.getHardware().getProcessor().getName();
        info.ram.total = this.systemInfo.getHardware().getMemory().getTotal();
        info.ram.swap = this.systemInfo.getHardware().getMemory().getVirtualMemory().getSwapTotal();
        for (HWDiskStore diskStore : this.systemInfo.getHardware().getDiskStores()) {
            Disk disk = new Disk(diskStore.getName(), diskStore.getModel(), diskStore.getSize());
            info.storage.disks.add(disk);
        }
        info.baseboard.model = this.systemInfo.getHardware().getComputerSystem().getBaseboard().getModel();
        info.baseboard.manufacturer = this.systemInfo.getHardware().getComputerSystem().getBaseboard().getManufacturer();
        info.operatingSystem.architecture = com.gamedash.daemon.system.OperatingSystem.getArchitecture().getName();
        return info;
    }

    static class OperatingSystem {
        @SerializedName(value="architecture")
        public String architecture;

        OperatingSystem() {
        }
    }

    static class Baseboard {
        @SerializedName(value="model")
        public String model;
        @SerializedName(value="manufacturer")
        public String manufacturer;

        Baseboard() {
        }
    }

    static class Disk {
        @SerializedName(value="name")
        public String name;
        @SerializedName(value="model")
        public String model;
        @SerializedName(value="size")
        public long size;

        public Disk(String name, String model, long size) {
            this.name = name;
            this.model = model;
            this.size = size;
        }
    }

    static class Storage {
        @SerializedName(value="disks")
        public List<Disk> disks = new ArrayList<Disk>();

        Storage() {
        }
    }

    static class Ram {
        @SerializedName(value="total")
        public long total;
        @SerializedName(value="swap")
        public long swap;

        Ram() {
        }
    }

    static class Cpu {
        @SerializedName(value="name")
        public String name;

        Cpu() {
        }
    }

    static class Info {
        @SerializedName(value="cpu")
        public Cpu cpu = new Cpu();
        @SerializedName(value="ram")
        public Ram ram = new Ram();
        @SerializedName(value="storage")
        public Storage storage = new Storage();
        @SerializedName(value="baseboard")
        public Baseboard baseboard = new Baseboard();
        @SerializedName(value="operatingSystem")
        public OperatingSystem operatingSystem = new OperatingSystem();

        Info() {
        }
    }
}

