/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.security.KeyPair;
import java.util.Objects;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.common.util.ValidateUtils;

public interface SimpleSftpClient
extends Channel {
    default public SftpClient sftpLogin(String host, String username, String password) throws IOException {
        return this.sftpLogin(host, 22, username, password);
    }

    default public SftpClient sftpLogin(String host, int port, String username, String password) throws IOException {
        return this.sftpLogin(InetAddress.getByName(ValidateUtils.checkNotNullAndNotEmpty(host, "No host")), port, username, password);
    }

    default public SftpClient sftpLogin(String host, String username, KeyPair identity) throws IOException {
        return this.sftpLogin(host, 22, username, identity);
    }

    default public SftpClient sftpLogin(String host, int port, String username, KeyPair identity) throws IOException {
        return this.sftpLogin(InetAddress.getByName(ValidateUtils.checkNotNullAndNotEmpty(host, "No host")), port, username, identity);
    }

    default public SftpClient sftpLogin(InetAddress host, String username, String password) throws IOException {
        return this.sftpLogin(host, 22, username, password);
    }

    default public SftpClient sftpLogin(InetAddress host, int port, String username, String password) throws IOException {
        return this.sftpLogin((SocketAddress)new InetSocketAddress(Objects.requireNonNull(host, "No host address"), port), username, password);
    }

    default public SftpClient sftpLogin(InetAddress host, String username, KeyPair identity) throws IOException {
        return this.sftpLogin(host, 22, username, identity);
    }

    default public SftpClient sftpLogin(InetAddress host, int port, String username, KeyPair identity) throws IOException {
        return this.sftpLogin((SocketAddress)new InetSocketAddress(Objects.requireNonNull(host, "No host address"), port), username, identity);
    }

    public SftpClient sftpLogin(SocketAddress var1, String var2, String var3) throws IOException;

    public SftpClient sftpLogin(SocketAddress var1, String var2, KeyPair var3) throws IOException;
}

