/*
 * Decompiled with CFR 0.152.
 */
package jtermios.solaris;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jtermios.FDSet;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;

public class JTermiosImpl
implements JTermios.JTermiosInterface {
    private static String DEVICE_DIR_PATH = "/dev/term/";
    static Solaris_C_lib m_Clib = Native.loadLibrary("c", Solaris_C_lib.class);

    public JTermiosImpl() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "instantiating %s\n", this.getClass().getCanonicalName());
        JTermios.FIONREAD = 1074030207;
        JTermios.O_RDWR = 2;
        JTermios.O_NONBLOCK = 128;
        JTermios.O_NOCTTY = 2048;
        JTermios.O_NDELAY = 4;
        JTermios.F_GETFL = 3;
        JTermios.F_SETFL = 4;
        JTermios.EAGAIN = 11;
        JTermios.EBADF = 9;
        JTermios.EACCES = 22;
        JTermios.EEXIST = 17;
        JTermios.EINTR = 4;
        JTermios.EINVAL = 22;
        JTermios.EIO = 5;
        JTermios.EISDIR = 21;
        JTermios.ELOOP = 90;
        JTermios.EMFILE = 24;
        JTermios.ENAMETOOLONG = 78;
        JTermios.ENFILE = 23;
        JTermios.ENOENT = 2;
        JTermios.ENOSR = 63;
        JTermios.ENOSPC = 28;
        JTermios.ENOTDIR = 20;
        JTermios.ENXIO = 6;
        JTermios.EOVERFLOW = 79;
        JTermios.EROFS = 30;
        JTermios.ENOTSUP = 48;
        JTermios.TIOCM_RNG = 128;
        JTermios.TIOCM_CAR = 64;
        JTermios.IGNBRK = 1;
        JTermios.BRKINT = 2;
        JTermios.IGNPAR = 4;
        JTermios.PARMRK = 8;
        JTermios.INLCR = 64;
        JTermios.IGNCR = 128;
        JTermios.ICRNL = 256;
        JTermios.ECHONL = 64;
        JTermios.IEXTEN = 32768;
        JTermios.CLOCAL = 2048;
        JTermios.OPOST = 1;
        JTermios.VSTART = 8;
        JTermios.TCSANOW = 21518;
        JTermios.VSTOP = 9;
        JTermios.VMIN = 4;
        JTermios.VTIME = 5;
        JTermios.VEOF = 4;
        JTermios.TIOCMGET = 29725;
        JTermios.TIOCM_CTS = 32;
        JTermios.TIOCM_DSR = 256;
        JTermios.TIOCM_RI = 128;
        JTermios.TIOCM_CD = 64;
        JTermios.TIOCM_DTR = 2;
        JTermios.TIOCM_RTS = 4;
        JTermios.ICANON = 2;
        JTermios.ECHO = 8;
        JTermios.ECHOE = 16;
        JTermios.ISIG = 1;
        JTermios.TIOCMSET = 29722;
        JTermios.IXON = 1024;
        JTermios.IXOFF = 4096;
        JTermios.IXANY = 2048;
        JTermios.CRTSCTS = Integer.MIN_VALUE;
        JTermios.TCSADRAIN = 21519;
        JTermios.INPCK = 16;
        JTermios.ISTRIP = 32;
        JTermios.CSIZE = 48;
        JTermios.TCIFLUSH = 0;
        JTermios.TCOFLUSH = 1;
        JTermios.TCIOFLUSH = 2;
        JTermios.CS5 = 0;
        JTermios.CS6 = 16;
        JTermios.CS7 = 32;
        JTermios.CS8 = 48;
        JTermios.CSTOPB = 64;
        JTermios.CREAD = 128;
        JTermios.PARENB = 256;
        JTermios.PARODD = 512;
        JTermios.B0 = 0;
        JTermios.B50 = 1;
        JTermios.B75 = 2;
        JTermios.B110 = 3;
        JTermios.B134 = 4;
        JTermios.B150 = 5;
        JTermios.B200 = 6;
        JTermios.B300 = 7;
        JTermios.B600 = 8;
        JTermios.B1200 = 8;
        JTermios.B1800 = 10;
        JTermios.B2400 = 11;
        JTermios.B4800 = 12;
        JTermios.B9600 = 13;
        JTermios.B19200 = 14;
        JTermios.B38400 = 15;
        JTermios.B57600 = 16;
        JTermios.B76800 = 17;
        JTermios.B115200 = 18;
        JTermios.B230400 = 20;
        JTermios.POLLIN = 1;
        JTermios.POLLPRI = (short)2;
        JTermios.POLLOUT = (short)4;
        JTermios.POLLERR = (short)8;
        JTermios.POLLNVAL = (short)32;
    }

    @Override
    public int errno() {
        return Native.getLastError();
    }

    @Override
    public void cfmakeraw(Termios termios2) {
        Solaris_C_lib.termios termios3 = new Solaris_C_lib.termios(termios2);
        termios3.c_iflag &= ~(JTermios.IGNBRK | JTermios.BRKINT | JTermios.PARMRK | JTermios.ISTRIP | JTermios.INLCR | JTermios.IGNCR | JTermios.ICRNL | JTermios.IXON);
        termios3.c_oflag &= ~JTermios.OPOST;
        termios3.c_lflag &= ~(JTermios.ECHO | JTermios.ECHONL | JTermios.ICANON | JTermios.ISIG | JTermios.IEXTEN);
        termios3.c_cflag &= ~(JTermios.CSIZE | JTermios.PARENB);
        termios3.c_cflag |= JTermios.CS8;
        termios3.update(termios2);
    }

    public int fcntl(int n, int n2, int[] nArray) {
        return m_Clib.fcntl(n, n2, nArray);
    }

    @Override
    public int fcntl(int n, int n2, int n3) {
        return m_Clib.fcntl(n, n2, n3);
    }

    @Override
    public int tcdrain(int n) {
        return m_Clib.tcdrain(n);
    }

    @Override
    public int cfgetispeed(Termios termios2) {
        return m_Clib.cfgetispeed(new Solaris_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfgetospeed(Termios termios2) {
        return m_Clib.cfgetospeed(new Solaris_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfsetispeed(Termios termios2, int n) {
        Solaris_C_lib.termios termios3 = new Solaris_C_lib.termios(termios2);
        int n2 = m_Clib.cfsetispeed(termios3, new NativeLong((long)n));
        termios3.update(termios2);
        return n2;
    }

    @Override
    public int cfsetospeed(Termios termios2, int n) {
        Solaris_C_lib.termios termios3 = new Solaris_C_lib.termios(termios2);
        int n2 = m_Clib.cfsetospeed(termios3, new NativeLong((long)n));
        termios3.update(termios2);
        return n2;
    }

    @Override
    public int open(String string, int n) {
        if (string != null && !string.startsWith("/")) {
            string = DEVICE_DIR_PATH + string;
        }
        return m_Clib.open(string, n);
    }

    @Override
    public int read(int n, byte[] byArray, int n2) {
        return m_Clib.read(n, ByteBuffer.wrap(byArray), new NativeLong((long)n2)).intValue();
    }

    @Override
    public int write(int n, byte[] byArray, int n2) {
        return m_Clib.write(n, ByteBuffer.wrap(byArray), new NativeLong((long)n2)).intValue();
    }

    @Override
    public int close(int n) {
        return m_Clib.close(n);
    }

    @Override
    public int tcflush(int n, int n2) {
        return m_Clib.tcflush(n, n2);
    }

    @Override
    public int tcgetattr(int n, Termios termios2) {
        Solaris_C_lib.termios termios3 = new Solaris_C_lib.termios();
        int n2 = m_Clib.tcgetattr(n, termios3);
        termios3.update(termios2);
        return n2;
    }

    @Override
    public void perror(String string) {
        m_Clib.perror(string);
    }

    @Override
    public int tcsendbreak(int n, int n2) {
        return m_Clib.tcsendbreak(n, n2 / 250);
    }

    @Override
    public int tcsetattr(int n, int n2, Termios termios2) {
        return m_Clib.tcsetattr(n, n2, new Solaris_C_lib.termios(termios2));
    }

    @Override
    public void FD_CLR(int n, FDSet fDSet) {
        if (fDSet == null) {
            return;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        int n2 = n / 32;
        fDSetImpl.bits[n2] = fDSetImpl.bits[n2] & ~(1 << n % 32);
    }

    @Override
    public boolean FD_ISSET(int n, FDSet fDSet) {
        if (fDSet == null) {
            return false;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        return (fDSetImpl.bits[n / 32] & 1 << n % 32) != 0;
    }

    @Override
    public void FD_SET(int n, FDSet fDSet) {
        if (fDSet == null) {
            return;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        int n2 = n / 32;
        fDSetImpl.bits[n2] = fDSetImpl.bits[n2] | 1 << n % 32;
    }

    @Override
    public void FD_ZERO(FDSet fDSet) {
        if (fDSet == null) {
            return;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        Arrays.fill(fDSetImpl.bits, 0);
    }

    @Override
    public int select(int n, FDSet fDSet, FDSet fDSet2, FDSet fDSet3, TimeVal timeVal) {
        Solaris_C_lib.timeval timeval2 = null;
        if (timeVal != null) {
            timeval2 = new Solaris_C_lib.timeval(timeVal);
        }
        int[] nArray = fDSet != null ? ((FDSetImpl)fDSet).bits : null;
        int[] nArray2 = fDSet2 != null ? ((FDSetImpl)fDSet2).bits : null;
        int[] nArray3 = fDSet3 != null ? ((FDSetImpl)fDSet3).bits : null;
        return m_Clib.select(n, nArray, nArray2, nArray3, timeval2);
    }

    @Override
    public int poll(Pollfd[] pollfdArray, int n, int n2) {
        int n3;
        Solaris_C_lib.pollfd[] pollfdArray2 = new Solaris_C_lib.pollfd[pollfdArray.length];
        for (n3 = 0; n3 < n; ++n3) {
            pollfdArray2[n3] = new Solaris_C_lib.pollfd(pollfdArray[n3]);
        }
        n3 = m_Clib.poll(pollfdArray2, n, n2);
        for (int i = 0; i < n; ++i) {
            pollfdArray[i].revents = pollfdArray2[i].revents;
        }
        return n3;
    }

    @Override
    public int poll(int[] nArray, int n, int n2) {
        return m_Clib.poll(nArray, n, n2);
    }

    @Override
    public FDSet newFDSet() {
        return new FDSetImpl();
    }

    @Override
    public int ioctl(int n, int n2, int[] nArray) {
        return m_Clib.ioctl(n, n2, nArray);
    }

    @Override
    public String getPortNamePattern() {
        return ".*";
    }

    @Override
    public List<String> getPortList() {
        File file = new File(DEVICE_DIR_PATH);
        if (!file.isDirectory()) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "device directory %s does not exist\n", DEVICE_DIR_PATH);
            return null;
        }
        String[] stringArray = file.list();
        LinkedList<String> linkedList = new LinkedList<String>();
        Pattern pattern = JTermios.getPortNamePattern(this);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!pattern.matcher(string).matches()) continue;
                linkedList.add(string);
            }
        }
        return linkedList;
    }

    @Override
    public void shutDown() {
    }

    @Override
    public int setspeed(int n, Termios termios2, int n2) {
        int n3 = n2;
        switch (n2) {
            case 50: {
                n3 = JTermios.B50;
                break;
            }
            case 75: {
                n3 = JTermios.B75;
                break;
            }
            case 110: {
                n3 = JTermios.B110;
                break;
            }
            case 134: {
                n3 = JTermios.B134;
                break;
            }
            case 150: {
                n3 = JTermios.B150;
                break;
            }
            case 200: {
                n3 = JTermios.B200;
                break;
            }
            case 300: {
                n3 = JTermios.B300;
                break;
            }
            case 600: {
                n3 = JTermios.B600;
                break;
            }
            case 1200: {
                n3 = JTermios.B1200;
                break;
            }
            case 1800: {
                n3 = JTermios.B1800;
                break;
            }
            case 2400: {
                n3 = JTermios.B2400;
                break;
            }
            case 4800: {
                n3 = JTermios.B4800;
                break;
            }
            case 9600: {
                n3 = JTermios.B9600;
                break;
            }
            case 19200: {
                n3 = JTermios.B19200;
                break;
            }
            case 38400: {
                n3 = JTermios.B38400;
                break;
            }
            case 7200: {
                n3 = JTermios.B7200;
                break;
            }
            case 14400: {
                n3 = JTermios.B14400;
                break;
            }
            case 28800: {
                n3 = JTermios.B28800;
                break;
            }
            case 57600: {
                n3 = JTermios.B57600;
                break;
            }
            case 76800: {
                n3 = JTermios.B76800;
                break;
            }
            case 115200: {
                n3 = JTermios.B115200;
                break;
            }
            case 230400: {
                n3 = JTermios.B230400;
            }
        }
        int n4 = this.cfsetispeed(termios2, n3);
        if (n4 != 0) {
            return n4;
        }
        n4 = this.cfsetospeed(termios2, n3);
        if (n4 != 0) {
            return n4;
        }
        n4 = this.tcsetattr(n, JTermios.TCSANOW, termios2);
        if (n4 != 0) {
            return n4;
        }
        return 0;
    }

    @Override
    public int pipe(int[] nArray) {
        return m_Clib.pipe(nArray);
    }

    private static class FDSetImpl
    extends FDSet {
        static final int FD_SET_SIZE = 1024;
        static final int NFBBITS = 32;
        int[] bits = new int[32];

        private FDSetImpl() {
        }

        public String toString() {
            return String.format("%08X%08X", this.bits[0], this.bits[1]);
        }
    }

    public static interface Solaris_C_lib
    extends Library {
        public int pipe(int[] var1);

        public int tcdrain(int var1);

        public int fcntl(int var1, int var2, int[] var3);

        public int fcntl(int var1, int var2, int var3);

        public int ioctl(int var1, int var2, int[] var3);

        public int open(String var1, int var2);

        public int close(int var1);

        public int tcgetattr(int var1, termios var2);

        public int tcsetattr(int var1, int var2, termios var3);

        public int cfsetispeed(termios var1, NativeLong var2);

        public int cfsetospeed(termios var1, NativeLong var2);

        public NativeLong cfgetispeed(termios var1);

        public NativeLong cfgetospeed(termios var1);

        public NativeLong write(int var1, ByteBuffer var2, NativeLong var3);

        public NativeLong read(int var1, ByteBuffer var2, NativeLong var3);

        public int select(int var1, int[] var2, int[] var3, int[] var4, timeval var5);

        public int poll(pollfd[] var1, int var2, int var3);

        public int poll(int[] var1, int var2, int var3);

        public int tcflush(int var1, int var2);

        public void perror(String var1);

        public int tcsendbreak(int var1, int var2);

        public static class termios
        extends Structure {
            public int c_iflag;
            public int c_oflag;
            public int c_cflag;
            public int c_lflag;
            public byte[] c_cc = new byte[32];

            protected List getFieldOrder() {
                return Arrays.asList("c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_cc");
            }

            public termios() {
            }

            public termios(Termios termios2) {
                this.c_iflag = termios2.c_iflag;
                this.c_oflag = termios2.c_oflag;
                this.c_cflag = termios2.c_cflag;
                this.c_lflag = termios2.c_lflag;
                System.arraycopy(termios2.c_cc, 0, this.c_cc, 0, termios2.c_cc.length);
            }

            public void update(Termios termios2) {
                termios2.c_iflag = this.c_iflag;
                termios2.c_oflag = this.c_oflag;
                termios2.c_cflag = this.c_cflag;
                termios2.c_lflag = this.c_lflag;
                System.arraycopy(this.c_cc, 0, termios2.c_cc, 0, termios2.c_cc.length);
            }
        }

        public static class pollfd
        extends Structure {
            public int fd;
            public short events;
            public short revents;

            protected List getFieldOrder() {
                return Arrays.asList("fd", "events", "revents");
            }

            public pollfd(Pollfd pollfd2) {
                this.fd = pollfd2.fd;
                this.events = pollfd2.events;
                this.revents = pollfd2.revents;
            }
        }

        public static class timeval
        extends Structure {
            public NativeLong tv_sec;
            public NativeLong tv_usec;

            protected List getFieldOrder() {
                return Arrays.asList("tv_sec", "tv_usec");
            }

            public timeval(TimeVal timeVal) {
                this.tv_sec = new NativeLong(timeVal.tv_sec);
                this.tv_usec = new NativeLong(timeVal.tv_usec);
            }
        }
    }
}

