/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.system.user.platform.linux;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.system.user.ISystemUser;
import com.gamedash.daemon.system.user.platform.linux.LinuxSystemUserException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class LinuxSystemUser
implements ISystemUser {
    private String name;

    public LinuxSystemUser(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void delete() throws Exception {
        this.killProcesses();
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("userdel", new String[]{this.getName()});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new LinuxSystemUserException("Could not delete");
        }
    }

    @Override
    public void setPassword(String password) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("bash", new String[]{"echo", "'" + this.getName() + ":" + password + "'", "|", "chpasswd"});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new LinuxSystemUserException("Could not set password");
        }
    }

    @Override
    public void assignFileSystemFilePermission(final File file) throws Exception {
        this.assignFileSystemFilePermission((List<File>)new ArrayList<File>(){
            {
                this.add(file);
            }
        });
    }

    @Override
    public void assignFileSystemFilePermission(final List<File> files) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        final String systemUserName = this.getName();
        ArrayList<String> args = new ArrayList<String>(){
            {
                this.add("-R");
                this.add("\"" + systemUserName + "\"");
                this.addAll(files.stream().map(file -> "\"" + file.getPath() + "\"").collect(Collectors.toList()));
            }
        };
        childProcess.spawn("chown", args.toArray(new String[0]));
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new LinuxSystemUserException("Could not assign permissions");
        }
    }

    @Override
    public void setHomeDirectory(File directory) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("usermod", new String[]{"-d", "\"" + directory.getPath() + "\"", "\"" + this.getName() + "\""});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new LinuxSystemUserException("Could not set home directory");
        }
    }

    private void killProcesses() throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("pkill", new String[]{"-u", "\"" + this.getName() + "\""});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0 && childProcess.getExitCode() != 1 && childProcess.getExitCode() != 2) {
            throw new LinuxSystemUserException("Could not kill processes");
        }
    }
}

