/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.generic;

import com.gamedash.daemon.process.ProcessException;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.process.childProcess.terminal.io.OutputHandler;
import com.gamedash.daemon.process.childProcess.terminal.io.OutputItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Io
extends OutputHandler
implements IIo {
    private static Logger logger = LoggerFactory.getLogger(Io.class);
    private boolean isListening = false;

    Io(ChildProcess childProcess) throws IOException {
        super(childProcess);
    }

    @Override
    public void write(String value) throws Exception {
        if (!this.childProcess.isRunning()) {
            return;
        }
        OutputStream outputStream = this.childProcess.getApi(Process.class).getOutputStream();
        outputStream.write((value + "\r\n").getBytes());
        outputStream.flush();
    }

    @Override
    public void listen() {
        if (this.isListening) {
            throw new ProcessException("Already listening to io");
        }
        this.isListening = true;
        new Thread(() -> {
            try {
                this.listenToInputStream(this.getInputStream(), false).join();
                this.listenToInputStream(this.getErrorStream(), true).join();
                this.setHasClosed(true);
                this.invokeOnCloseListener();
            }
            catch (Exception e) {
                if (e instanceof IOException && this.childProcess.isTerminating()) {
                    return;
                }
                logger.error(e.getMessage());
            }
        }).start();
    }

    @Override
    public void destroy() throws Exception {
        this.getInputStream().close();
        this.getErrorStream().close();
    }

    private InputStream getInputStream() throws Exception {
        return this.childProcess.getApi(Process.class).getInputStream();
    }

    private InputStream getErrorStream() throws Exception {
        return this.childProcess.getApi(Process.class).getErrorStream();
    }

    private Thread listenToInputStream(InputStream inputStream, boolean isErrorStream) {
        Thread thread = new Thread(() -> {
            block5: {
                try {
                    String value;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((value = bufferedReader.readLine()) != null) {
                        try {
                            OutputItem outputItem = new OutputItem(value, isErrorStream);
                            this.addOutputItem(outputItem);
                            this.invokeOnOutputListener(outputItem);
                        }
                        catch (Exception e) {
                            logger.error(ExceptionUtils.getStackTrace(e));
                        }
                    }
                    bufferedReader.close();
                }
                catch (Exception e) {
                    if (e instanceof IOException && this.childProcess.isTerminating()) break block5;
                    logger.error(e.getMessage());
                }
            }
        });
        thread.start();
        return thread;
    }
}

