/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.generic;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.terminal.AbstractTerminal;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.generic.Io;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generic
extends AbstractTerminal
implements ITerminal {
    public static final Logger logger = LoggerFactory.getLogger(Generic.class);
    private IIo io;
    private ChildProcess childProcess;
    private Process api;
    private int id;

    public Generic(ChildProcess childProcess) throws IOException {
        this.childProcess = childProcess;
        this.io = new Io(this.childProcess);
    }

    @Override
    public void spawn(String[] args) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        if (this.childProcess.hasWorkingDirectory().booleanValue()) {
            processBuilder.directory(this.childProcess.getWorkingDirectory());
        }
        processBuilder.environment().putAll(this.childProcess.getEnvironmentVariables());
        this.api = processBuilder.start();
        this.listenForExit();
        this.getIo().listen();
        this.id = (int)this.api.pid();
    }

    @Override
    public void stop() throws Exception {
        this.getIo().destroy();
        IProcess[] children = (IProcess[])this.childProcess.getChildren().toArray(IProcess[]::new);
        if (this.api.supportsNormalTermination()) {
            this.api.destroy();
        } else {
            this.api.destroyForcibly();
        }
        this.waitForExit(10);
        this.api.destroyForcibly();
        if (children.length > 0) {
            Processes.stop(children);
        }
        this.waitForExit();
    }

    @Override
    public int getExitCode() {
        return this.api.exitValue();
    }

    @Override
    public boolean isRunning() {
        if (this.api == null) {
            return false;
        }
        return this.api.isAlive();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public IIo getIo() {
        return this.io;
    }

    @Override
    public <T> T getApi(Class<T> type) {
        return type.cast(this.api);
    }

    private void listenForExit() {
        Thread thread = new Thread(() -> {
            try {
                if (this.isRunning()) {
                    this.api.waitFor();
                }
                this.io.waitFor();
                this.handleExit();
            }
            catch (Exception e) {
                logger.debug(ExceptionUtils.getStackTrace(e));
            }
        });
        thread.start();
    }
}

