/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process;

import com.gamedash.daemon.exception.InvalidArgumentException;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.platform.linux.LinuxProcess;
import com.gamedash.daemon.process.platform.linux.LinuxProcesses;
import com.gamedash.daemon.process.platform.windows.WindowsProcesses;
import com.gamedash.daemon.system.UnsupportedOperatingSystemException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;

public class Processes {
    public static List<IProcess> getAll() throws Exception {
        ArrayList<IProcess> processes = new ArrayList<IProcess>();
        processes.addAll(SystemUtils.IS_OS_LINUX ? LinuxProcesses.getAll() : WindowsProcesses.getAll());
        return processes;
    }

    public static IProcess get(int id) throws Exception {
        if (SystemUtils.IS_OS_LINUX) {
            return LinuxProcesses.get(id);
        }
        return WindowsProcesses.get(id);
    }

    public static boolean exists(int id) throws Exception {
        if (SystemUtils.IS_OS_LINUX) {
            return LinuxProcesses.exists(id);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return WindowsProcesses.exists(id);
        }
        throw new UnsupportedOperatingSystemException();
    }

    public static void stop(IProcess[] processes) throws Exception {
        if (processes.length < 1) {
            throw new InvalidArgumentException("No processes given");
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            WindowsProcesses.stop(WindowsProcesses.filter(processes));
        } else if (SystemUtils.IS_OS_LINUX) {
            LinuxProcesses.stop(LinuxProcesses.filter(processes));
        }
    }

    public static void kill(IProcess[] processes) throws Exception {
        if (processes.length < 1) {
            throw new InvalidArgumentException("No processes given");
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            WindowsProcesses.kill(WindowsProcesses.filter(processes));
        } else if (SystemUtils.IS_OS_LINUX) {
            Processes.kill(LinuxProcesses.filter(processes), "SIGKILL");
        }
    }

    public static void kill(LinuxProcess[] processes, String signal) throws Exception {
        LinuxProcesses.kill(processes, signal);
    }

    public static boolean processIsSelf(IProcess process) {
        return ProcessHandle.current().pid() == (long)process.getId();
    }
}

