/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.remote.host.implementation.sftp;

import com.gamedash.daemon.fileSystem.remote.host.implementation.sftp.SFTPHostImplementation;
import com.gamedash.daemon.fileSystem.remote.user.RemoteFileSystemUser;
import com.gamedash.daemon.fileSystem.remote.user.RemoteFileSystemUsers;
import com.google.common.io.Files;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.FileHandle;
import org.apache.sshd.server.subsystem.sftp.Handle;
import org.apache.sshd.server.subsystem.sftp.SftpEventListener;

public class SFTPEventListener
implements SftpEventListener {
    private SFTPHostImplementation host;

    public SFTPEventListener(SFTPHostImplementation host) {
        this.host = host;
    }

    @Override
    public void reading(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) throws IOException {
        try {
            RemoteFileSystemUser user = RemoteFileSystemUsers.get(session.getUsername());
            if (user.getFiles().getExtensions().getBlacklisted().contains(Files.getFileExtension(localHandle.getFile().toString()))) {
                throw new IOException("File is blacklisted");
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void writing(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) throws IOException {
        try {
            this.host.getStats().filesBeingWritten.add(localHandle.getFile().toFile().toString());
            RemoteFileSystemUser user = RemoteFileSystemUsers.get(session.getUsername());
            if (user.getFiles().getExtensions().getBlacklisted().contains(Files.getFileExtension(localHandle.getFile().toString()))) {
                throw new IOException("File is blacklisted");
            }
            long rootDirectorySize = FileUtils.sizeOfDirectory(user.getFiles().getRootDirectory());
            Long allocationSize = user.getFiles().getAllocationSize();
            if (allocationSize != null && rootDirectorySize + (long)data.length > allocationSize * 1000000L) {
                throw new IOException("Max size exceeded");
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void closing(ServerSession session, String remoteHandle, Handle localHandle) throws IOException {
        try {
            RemoteFileSystemUser user = RemoteFileSystemUsers.get(session.getUsername());
            if (this.host.getStats().filesBeingWritten.contains(localHandle.getFile().toFile().toString())) {
                this.host.getStats().filesBeingWritten.remove(localHandle.getFile().toFile().toString());
                if (user.getSystemUser() != null) {
                    user.getSystemUser().assignFileSystemFilePermission(localHandle.getFile().toFile());
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void creating(ServerSession session, Path path, Map<String, ?> attrs) throws IOException {
        try {
            RemoteFileSystemUser user = RemoteFileSystemUsers.get(session.getUsername());
            if (user.getFiles().getExtensions().getBlacklisted().contains(Files.getFileExtension(path.toString()))) {
                throw new IOException("File is blacklisted");
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void created(ServerSession session, Path path, Map<String, ?> attrs, Throwable throwable) throws IOException {
        try {
            RemoteFileSystemUser user = RemoteFileSystemUsers.get(session.getUsername());
            if (user.getSystemUser() != null) {
                user.getSystemUser().assignFileSystemFilePermission(path.toFile());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void moving(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts) throws IOException {
        try {
            RemoteFileSystemUser user = RemoteFileSystemUsers.get(session.getUsername());
            List<String> blacklistedExtensions = user.getFiles().getExtensions().getBlacklisted();
            if (blacklistedExtensions.contains(Files.getFileExtension(srcPath.toString()))) {
                throw new IOException("Source file is blacklisted");
            }
            if (blacklistedExtensions.contains(Files.getFileExtension(dstPath.toString()))) {
                throw new IOException("Destination file is blacklisted");
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void removing(ServerSession session, Path path, boolean isDirectory) throws IOException {
        try {
            RemoteFileSystemUser user = RemoteFileSystemUsers.get(session.getUsername());
            if (user.getFiles().getExtensions().getBlacklisted().contains(Files.getFileExtension(path.toString()))) {
                throw new IOException("File is blacklisted");
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

