/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency;

import com.gamedash.daemon.dependency.Dependencies;
import com.gamedash.daemon.dependency.DependencyAnnotation;
import com.gamedash.daemon.dependency.IDependency;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dependency {
    private static Logger logger = LoggerFactory.getLogger(Dependency.class);
    private Class<? extends IDependency> dependencyClass;
    private IDependency instance;

    public Dependency(Class<? extends IDependency> dependencyClass) {
        this.dependencyClass = dependencyClass;
    }

    public String getName() {
        DependencyAnnotation annotation = this.getAnnotation();
        return annotation != null ? annotation.name() : null;
    }

    public void install() throws Exception {
        if (this.isInstalled()) {
            throw new Exception("Dependency " + this.getName() + " is already installed");
        }
        logger.info("Installing dependency " + this.getName());
        this.getInstance().install();
        Dependencies.addInstalled(this);
        logger.info("Finished installed dependency " + this.getName());
    }

    public void uninstall() throws Exception {
        if (!this.isInstalled()) {
            throw new Exception("Dependency " + this.getName() + " is not installed");
        }
        this.getInstance().uninstall();
        Dependencies.removeInstalled(this);
    }

    public boolean isInstalled() throws Exception {
        for (Dependency dependency : Dependencies.getInstalled()) {
            if (!dependency.getName().equals(this.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isAvailable() throws Exception {
        return this.getInstance().isAvailable();
    }

    public Class<? extends IDependency> getDependencyClass() {
        return this.dependencyClass;
    }

    private DependencyAnnotation getAnnotation() {
        for (Annotation annotation : this.getDependencyClass().getAnnotations()) {
            if (!(annotation instanceof DependencyAnnotation)) continue;
            return (DependencyAnnotation)annotation;
        }
        return null;
    }

    private IDependency getInstance() throws Exception {
        if (this.instance == null) {
            this.instance = this.dependencyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return this.instance;
    }
}

