/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.group;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.zeroturnaround.zip.commons.FileUtils;

public class Copy
extends Route<String> {
    public Copy(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        List<String> filePaths = this.request.getInput().getParameters().get("files").getList();
        File directory = com.gamedash.daemon.fileSystem.file.FileUtils.fromBase64(this.request.getInput().getParameters().get("directory").getValue());
        if (directory.exists() && !directory.isDirectory()) {
            throw new FileNotFoundException("Directory does not exist");
        }
        for (String filePath : filePaths) {
            File file = com.gamedash.daemon.fileSystem.file.FileUtils.fromBase64(filePath);
            if (file.isDirectory()) {
                FileUtils.copyDirectory(file, new File(directory.getPath() + "/" + file.getName()));
                continue;
            }
            FileUtils.copyFile(file, new File(directory.getPath() + "/" + file.getName()));
        }
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"files", "directory"};
    }
}

