/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.download;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderSession;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderSessionNotFoundException;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderSessionResult;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderSessions;
import com.google.gson.annotations.SerializedName;
import java.util.UUID;

public class GetDownloadSession
extends Route<Object> {
    public GetDownloadSession(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Result execute() throws Exception {
        UUID id = UUID.fromString(this.request.getInput().getParameters().get("session_id").getValue());
        FileDownloaderSession session = FileDownloaderSessions.get(id);
        if (session == null) {
            throw new FileDownloaderSessionNotFoundException("Download session " + id + " does not exist");
        }
        return new Result(session);
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"session_id"};
    }

    private static class Result {
        @SerializedName(value="name")
        private UUID id;
        @SerializedName(value="progressPercentage")
        private double progressPercentage;
        @SerializedName(value="hasSucceeded")
        private boolean hasSucceeded;
        @SerializedName(value="message")
        private String message;
        @SerializedName(value="code")
        private String code;
        @SerializedName(value="hasEnded")
        private boolean hasEnded;

        public Result(FileDownloaderSession session) {
            this.id = session.getId();
            this.progressPercentage = session.getProgressPercentage();
            this.hasEnded = session.hasEnded();
            if (session.hasResult()) {
                FileDownloaderSessionResult result = session.getResult();
                this.hasSucceeded = result.hasSucceeded();
                this.message = result.getMessage();
                this.code = result.getCode();
            }
        }
    }
}

