/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.download;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.api.server.route.routes.fileSystem.FileSystemSystemUserTrait;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloader;
import com.gamedash.daemon.system.user.SystemUser;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Base64;

public class Download
extends Route<String>
implements FileSystemSystemUserTrait {
    public Download(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File destination = FileUtils.fromBase64(this.request.getInput().getParameters().get("destination").getValue());
        if (destination.exists() && !destination.isFile()) {
            throw new FileNotFoundException("Destination already exists, but is not a file");
        }
        try {
            URL url = new URL(new String(Base64.getDecoder().decode(this.request.getInput().getParameters().get("url").getValue())));
            FileDownloader fileDownloader = new FileDownloader(destination, url);
            fileDownloader.download();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        SystemUser systemUser = this.getSystemUser(this.request, "systemUserName");
        if (systemUser != null) {
            systemUser.assignFileSystemFilePermission(destination);
        }
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"destination", "url"};
    }
}

