/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.api.server.route.routes.fileSystem.FileSystemSystemUserTrait;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import com.gamedash.daemon.system.user.SystemUser;
import java.io.File;
import java.io.FileNotFoundException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.zip.ZipUtil;

public class Unzip
extends Route<String>
implements FileSystemSystemUserTrait {
    public static final Logger logger = LoggerFactory.getLogger(Unzip.class);

    public Unzip(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File origin = FileUtils.fromBase64(this.request.getInput().getParameters().get("origin").getValue());
        File destination = FileUtils.fromBase64(this.request.getInput().getParameters().get("destination").getValue());
        if (!origin.exists() || !origin.isFile()) {
            throw new FileNotFoundException("Origin file does not exist");
        }
        if (!destination.exists() || !destination.isDirectory()) {
            throw new FileNotFoundException("Destination directory does not exist");
        }
        ZipUtil.unpack(origin, destination);
        SystemUser systemUser = this.getSystemUser(this.request, "systemUserName");
        if (systemUser != null) {
            ZipUtil.iterate(origin, (in, zipEntry) -> {
                try {
                    systemUser.assignFileSystemFilePermission(new File(destination.getPath(), zipEntry.getName()));
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                }
            });
        }
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"origin", "destination"};
    }
}

