/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;

public class Move
extends Route<String> {
    public Move(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File origin = FileUtils.fromBase64(this.request.getInput().getParameters().get("origin").getValue());
        File destination = FileUtils.fromBase64(this.request.getInput().getParameters().get("destination").getValue());
        if (!origin.exists() || !origin.isFile()) {
            throw new FileNotFoundException("Origin does not exist");
        }
        if (origin.compareTo(destination) == 0) {
            throw new FileNotFoundException("Can not move a file to itself");
        }
        if (destination.exists()) {
            destination.delete();
        }
        org.apache.commons.io.FileUtils.moveFile(origin, destination);
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"origin", "destination"};
    }
}

