/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.request.input.parameter;

import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.request.input.parameter.RequestParameter;
import com.gamedash.daemon.common.utilities.QueryString;
import java.util.ArrayList;
import java.util.List;

public class RequestParameters {
    private Request request;
    private List<RequestParameter> parameters = new ArrayList<RequestParameter>();

    public RequestParameters(Request request) {
        this.request = request;
        this.collect();
    }

    public List<RequestParameter> getAll() {
        return this.parameters;
    }

    public RequestParameter get(String name) {
        for (RequestParameter parameter : this.getAll()) {
            if (!parameter.getName().equalsIgnoreCase(name)) continue;
            return parameter;
        }
        return null;
    }

    public boolean exists(String name) {
        return this.get(name) != null;
    }

    public RequestParameter create(String name, String value) {
        RequestParameter parameter = new RequestParameter(name, value);
        this.parameters.add(parameter);
        return parameter;
    }

    private void collect() {
        if (this.request.getContentType() == null || !this.request.getContentType().substring(0, "multipart/form-data".length()).equalsIgnoreCase("multipart/form-data")) {
            QueryString.decode(this.request.getSparkRequest().body()).forEach(this::create);
        }
        this.request.getSparkRequest().params().forEach((name, value) -> this.create(name.substring(1), (String)value));
        this.request.getSparkRequest().queryParams().forEach(name -> this.create((String)name, this.request.getSparkRequest().queryParams((String)name)));
    }
}

