/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.request.input.parameter;

import com.gamedash.daemon.api.server.request.input.parameter.RequestParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class RequestParameter {
    private String name;
    private String value;

    public RequestParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() throws RequestParameterException {
        return this.getValue(String.class);
    }

    public <T> T getValue(Class<T> type) throws RequestParameterException {
        if (type.equals(String.class)) {
            return type.cast(this.value);
        }
        if (type.equals(Boolean.class)) {
            return type.cast(this.value.equalsIgnoreCase("true"));
        }
        if (type.equals(Integer.class)) {
            return type.cast(Integer.valueOf(this.value));
        }
        if (type.equals(Long.class)) {
            return type.cast(Long.valueOf(this.value));
        }
        throw new RequestParameterException("Parameter " + this.name + " has an invalid type of " + type.getName());
    }

    public List<String> getList() {
        if (this.value.equals("")) {
            return new ArrayList<String>();
        }
        return Arrays.asList(this.value.split(","));
    }

    public List<Integer> getIntegerList() {
        return this.getLongList().stream().map(Math::toIntExact).collect(Collectors.toList());
    }

    public List<Long> getLongList() {
        ArrayList<Long> values = new ArrayList<Long>();
        for (String value : this.getList()) {
            try {
                values.add(Long.parseLong(value));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return values;
    }
}

