/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.authentication;

import com.gamedash.daemon.api.server.authentication.NotAuthenticatedException;
import com.gamedash.daemon.api.server.request.Request;
import com.gamedash.daemon.api.server.response.Response;
import com.gamedash.daemon.common.authentication.AuthenticationToken;
import com.gamedash.daemon.common.development.DevelopmentMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authentication {
    private static Logger logger = LoggerFactory.getLogger(Authentication.class);
    private Request request;

    public Authentication(Request request) {
        this.request = request;
    }

    public boolean isAuthenticated() throws Exception {
        if (DevelopmentMode.isEnabled()) {
            logger.warn("Development mode is enabled, so authentication of requests is skipped");
            return true;
        }
        if (this.request.getHeader("x-daemon-token") == null) {
            return false;
        }
        AuthenticationToken authenticationToken = new AuthenticationToken(this.request.getHeader("x-daemon-token"));
        return authenticationToken.validate().isValid();
    }

    public static void ensureAuthenticated(Request request, Response response) throws Exception {
        Authentication authentication = new Authentication(request);
        if (!authentication.isAuthenticated()) {
            throw new NotAuthenticatedException("Could not authenticate");
        }
    }
}

