/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDTM
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(MDTM.class);

    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        String fileName = request.getArgument();
        if (fileName == null) {
            session.write(LocalizedFtpReply.translate(session, request, context, 501, "MDTM", null));
            return;
        }
        FtpFile file = null;
        try {
            file = session.getFileSystemView().getFile(fileName);
        }
        catch (Exception ex) {
            this.LOG.debug("Exception getting file object", ex);
        }
        if (file == null) {
            session.write(LocalizedFtpReply.translate(session, request, context, 550, "MDTM", fileName));
            return;
        }
        fileName = file.getAbsolutePath();
        if (file.doesExist()) {
            String dateStr = DateUtils.getFtpDate(file.getLastModified());
            session.write(LocalizedFtpReply.translate(session, request, context, 213, "MDTM", dateStr));
        } else {
            session.write(LocalizedFtpReply.translate(session, request, context, 550, "MDTM", fileName));
        }
    }
}

