/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.windows.process.childProcess.io;

import com.gamedash.daemon.windows.IWindowsBridge;
import com.gamedash.daemon.windows.WindowsBridge;
import com.gamedash.daemon.windows.process.childProcess.WindowsBridgeChildProcess;
import com.gamedash.daemon.windows.process.childProcess.io.IOException;
import com.gamedash.daemon.windows.process.childProcess.io.IOnOutputCallback;
import com.gamedash.daemon.windows.process.childProcess.io.OutputItem;
import com.gamedash.daemon.windows.result.WindowsBridgeResult;
import com.gamedash.daemon.windows.result.WindowsBridgeResults;
import java.util.ArrayList;
import java.util.List;

public class Io {
    private WindowsBridgeChildProcess childProcess;
    private List<OnOutputHandle> onOutputHandles = new ArrayList<OnOutputHandle>();
    private List<IOnOutputCallback> onOutputCallbacks = new ArrayList<IOnOutputCallback>();
    private boolean isListening = false;
    private IWindowsBridge.IChildProcessOnOutputCallback onOutputListener;

    public Io(WindowsBridgeChildProcess childProcess) {
        this.childProcess = childProcess;
    }

    public void onOutput(IOnOutputCallback callback) {
        this.onOutputCallbacks.add(callback);
    }

    public boolean isListening() {
        return this.isListening;
    }

    private void setIsListening(boolean isListening) {
        this.isListening = isListening;
    }

    public void listen() throws IOException {
        if (this.isListening()) {
            throw new IOException("Already listening");
        }
        this.setIsListening(true);
        this.onOutputListener = (value, isError) -> this.onOutputCallbacks.forEach(callback -> callback.method(new OutputItem(value, isError)));
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().onChildProcessOutput(this.childProcess.getId(), this.onOutputListener));
        if (result.isError()) {
            throw new IOException(result.getErrorMessage());
        }
        OnOutputHandle handle = new OnOutputHandle(this.childProcess, result.getResultValueAsInteger());
        this.onOutputHandles.add(handle);
    }

    public void destroy() {
        for (OnOutputHandle handle : this.onOutputHandles) {
            handle.remove();
        }
    }

    public static class OnOutputHandle {
        private WindowsBridgeChildProcess childProcess;
        private int index;

        public OnOutputHandle(WindowsBridgeChildProcess childProcess, int index) {
            this.index = index;
            this.childProcess = childProcess;
        }

        public void remove() {
            WindowsBridge.getInstance().removeChildProcessOnOutputCallback(this.childProcess.getId(), this.index);
        }
    }
}

