/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.platform.windows;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessResourceUsageResult;
import com.gamedash.daemon.process.platform.AbstractProcess;
import com.gamedash.daemon.process.platform.windows.WindowsResourceLimitEnforcementManager;
import com.gamedash.daemon.process.resource.limit.CPUResourceLimit;
import com.gamedash.daemon.process.resource.limit.IResourceLimitEnforcementManager;
import com.gamedash.daemon.windows.process.WindowsBridgeProcess;
import com.gamedash.daemon.windows.process.WindowsBridgeResourceProcessUsage;
import com.gamedash.daemon.windows.process.priority.WindowsBridgeProcessPriorityHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class WindowsProcess
extends AbstractProcess {
    private final WindowsBridgeProcess api;

    public WindowsProcess(WindowsBridgeProcess api) {
        super(api.getId());
        this.api = api;
    }

    @Override
    public String getName() {
        return this.api.getName();
    }

    @Override
    public String[] getCommandLine() {
        String[] cmdLine = new String[]{this.getFileName()};
        return ArrayUtils.addAll(cmdLine, this.getArguments());
    }

    public String getFileName() {
        return this.api.getFileName();
    }

    public String[] getArguments() {
        return this.api.getArguments();
    }

    @Override
    public File getWorkingDirectory() {
        return this.api.getWorkingDirectory();
    }

    @Override
    public List<IProcess> getChildren() throws Exception {
        ArrayList<IProcess> processes = new ArrayList<IProcess>();
        for (WindowsBridgeProcess process : this.api.getChildren()) {
            processes.add(new WindowsProcess(process));
        }
        return processes;
    }

    @Override
    public void kill() throws Exception {
        this.api.kill();
    }

    @Override
    public void kill(String signal) throws Exception {
        this.api.kill();
    }

    @Override
    public void stop() throws Exception {
        this.api.kill();
    }

    @Override
    public ProcessResourceUsageResult getResourceUsage() throws Exception {
        WindowsBridgeResourceProcessUsage apiResourceUsage = this.api.getResourceUsage();
        return new ProcessResourceUsageResult(apiResourceUsage.getCpuPercentage(), apiResourceUsage.getRamMb());
    }

    @Override
    public void enforceResourceLimits() throws Exception {
        this.enforceCPUResourceLimit();
    }

    public void enforceCPUResourceLimit() throws Exception {
        CPUResourceLimit cpu = this.getCPUResourceLimit();
        if (cpu.getProcessorAffinity() != null) {
            this.ensureAffinityProcessorsIsInRange(cpu.getProcessorAffinity());
            this.api.setProcessorAffinity(cpu.getProcessorAffinity());
        }
        if (cpu.getPriority() != null) {
            this.api.setPriority(WindowsBridgeProcessPriorityHelper.from(cpu.getPriority()));
        }
    }

    @Override
    protected IResourceLimitEnforcementManager createResourceLimitEnforcementManager() {
        return new WindowsResourceLimitEnforcementManager(this);
    }
}

