/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.reference;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.reference.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class References {
    private ChildProcess childProcess;
    private static List<Reference> references = new CopyOnWriteArrayList<Reference>(new ArrayList());

    public References(ChildProcess childProcess) {
        this.childProcess = childProcess;
    }

    public static List<Reference> getAll() {
        return references;
    }

    public static boolean exists(String name) {
        for (Reference reference : References.getAll()) {
            if (!reference.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public List<Reference> getAllLocal() {
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (Reference reference : References.getAll()) {
            if (!reference.getChildProcess().getId().equals(this.childProcess.getId())) continue;
            references.add(reference);
        }
        return references;
    }

    public void removeAllLocal() {
        for (Reference reference : this.getAllLocal()) {
            References.getAll().remove(reference);
        }
    }

    public Reference create(String name) throws Exception {
        if (References.exists(name)) {
            throw new Exception(String.format("Reference %s already exists", name));
        }
        Reference reference = new Reference(this.childProcess, name);
        references.add(reference);
        return reference;
    }
}

