/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.linux.cgroup.resource;

import com.gamedash.daemon.linux.cgroup.LinuxCGroup;
import com.gamedash.daemon.linux.cgroup.LinuxCGroupException;
import com.gamedash.daemon.linux.cgroup.controller.RAMController;
import com.gamedash.daemon.linux.cgroup.resource.AbstractResource;
import com.gamedash.daemon.linux.cgroup.resource.IResource;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;

public class RAMResource
extends AbstractResource
implements IResource {
    private LinuxCGroup cGroup;
    private int mb;

    public RAMResource(LinuxCGroup cGroup) {
        super(cGroup, new RAMController());
        this.cGroup = cGroup;
    }

    public int getMb() {
        return this.mb;
    }

    public void setMB(int mb) throws Exception {
        this.mb = mb;
    }

    @Override
    public void limitProcess(IProcess process) throws Exception {
        super.limitProcess(process);
        this.pushLimit();
        if (!this.cGroup.getProcess(process.getId()).resourceIsLimited(this)) {
            this.cGroup.getProcess(process.getId()).addLimitedResource(this);
        }
    }

    private void pushLimit() throws Exception {
        ChildProcess process = ChildProcesses.create();
        process.setCanInterrupt(false);
        process.spawn("cgset -r memory.limit_in_bytes=" + this.mb + "m " + this.cGroup.getName());
        process.waitForExit();
        if (process.getExitCode() != 0) {
            throw new LinuxCGroupException("Could not set RAM limit");
        }
    }
}

