/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.linux;

import com.gamedash.daemon.linux.LinuxDistroEnum;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Scanner;

public class LinuxRelease {
    private LinuxDistroEnum distro;
    private String version;

    public LinuxRelease(LinuxDistroEnum distro, String version) {
        this.distro = distro;
        this.version = version;
    }

    public String getName() {
        return this.getDistro().getName();
    }

    public LinuxDistroEnum getDistro() {
        return this.distro;
    }

    public String getVersion() {
        return this.version;
    }

    public static LinuxRelease parseFile(File file) throws FileNotFoundException {
        HashMap<String, String> settings = new HashMap<String, String>();
        Scanner scanner = new Scanner(file);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            String[] lineBits = line.split("=");
            if (lineBits.length < 2) continue;
            String name = lineBits[0];
            String value = lineBits[1];
            settings.put(name, value.contains("\"") ? value.split("\"")[1] : value);
        }
        LinuxDistroEnum distro = null;
        if (((String)settings.get("NAME")).equalsIgnoreCase("ubuntu")) {
            distro = LinuxDistroEnum.ubuntu;
        } else if (((String)settings.get("NAME")).equalsIgnoreCase("debian")) {
            distro = LinuxDistroEnum.debian;
        } else if (((String)settings.get("NAME")).equalsIgnoreCase("centos linux")) {
            distro = LinuxDistroEnum.centos;
        }
        return new LinuxRelease(distro, (String)settings.get("VERSION_ID"));
    }
}

