/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.remote.host.implementation.sftp;

import com.gamedash.daemon.fileSystem.remote.host.implementation.IRemoteFileSystemHostImplementation;
import com.gamedash.daemon.fileSystem.remote.host.implementation.sftp.SFTPEventListener;
import com.gamedash.daemon.fileSystem.remote.host.implementation.sftp.SFTPStats;
import com.gamedash.daemon.fileSystem.remote.host.implementation.sftp.fileSystem.FileSystemFactory;
import com.gamedash.daemon.fileSystem.remote.user.RemoteFileSystemUser;
import com.gamedash.daemon.fileSystem.remote.user.RemoteFileSystemUsers;
import com.gamedash.daemon.fileSystem.remote.user.authentication.RemoteFileSystemUserAuthentication;
import com.gamedash.daemon.fileSystem.remote.user.authentication.RemoteFileSystemUserAuthenticationResult;
import com.gamedash.daemon.fileSystem.remote.user.session.RemoteFileSystemUserSession;
import com.gamedash.daemon.ssh.SSH;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.AsyncAuthException;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.PasswordChangeRequiredException;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.SubsystemFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFTPHostImplementation
implements IRemoteFileSystemHostImplementation {
    private static Logger logger = LoggerFactory.getLogger(SFTPHostImplementation.class);
    private SshServer api;
    private SFTPStats stats = new SFTPStats();
    private boolean isRunning = false;
    private int port = 22;

    @Override
    public void start() throws IOException {
        SshServer instance;
        if (this.isRunning()) {
            throw new RuntimeException("Already running");
        }
        this.api = instance = SshServer.setUpDefaultServer();
        this.api.setPort(this.getPort());
        this.api.setPasswordAuthenticator(new PasswordAuthenticator(){

            @Override
            public boolean authenticate(String username, String password, ServerSession session) throws PasswordChangeRequiredException, AsyncAuthException {
                try {
                    RemoteFileSystemUserAuthenticationResult result = RemoteFileSystemUserAuthentication.authenticate(username, password);
                    if (!result.isValid()) {
                        return false;
                    }
                    RemoteFileSystemUser user = RemoteFileSystemUsers.get(username);
                    return user.getFiles().getRootDirectory() != null && user.getFiles().getRootDirectory().exists();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                    return false;
                }
            }

            @Override
            public boolean handleClientPasswordChangeRequest(ServerSession session, String username, String oldPassword, String newPassword) {
                return false;
            }
        });
        this.api.setKeyPairProvider(new SimpleGeneratorHostKeyProvider(SSH.getHostKeyFile().toPath()));
        this.api.setFileSystemFactory(new FileSystemFactory());
        SftpSubsystemFactory sftpSubsystemFactory = new SftpSubsystemFactory();
        sftpSubsystemFactory.addSftpEventListener(new SFTPEventListener(this));
        ArrayList<SubsystemFactory> factoryList = new ArrayList<SubsystemFactory>();
        factoryList.add(sftpSubsystemFactory);
        this.api.setSubsystemFactories(factoryList);
        this.api.start();
        this.setIsRunning(true);
    }

    @Override
    public void stop() throws IOException {
        if (!this.isRunning()) {
            throw new RuntimeException("Not running");
        }
        this.api.stop();
        this.setIsRunning(false);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    private void setIsRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    public SFTPStats getStats() {
        return this.stats;
    }

    @Override
    public List<RemoteFileSystemUserSession> getSessions() throws Exception {
        List<AbstractSession> apiSessions = this.api.getActiveSessions();
        ArrayList<RemoteFileSystemUserSession> sessions = new ArrayList<RemoteFileSystemUserSession>();
        for (AbstractSession apiSession : apiSessions) {
            sessions.add(new RemoteFileSystemUserSession(RemoteFileSystemUsers.get(apiSession.getUsername()), this, (InetSocketAddress)apiSession.getRemoteAddress()));
        }
        return sessions;
    }

    @Override
    public RemoteFileSystemUserSession getSessionByAddress(InetSocketAddress socketAddress) throws Exception {
        for (RemoteFileSystemUserSession session : this.getSessions()) {
            if (!session.getSocketAddress().equals(socketAddress)) continue;
            return session;
        }
        return null;
    }

    @Override
    public void disconnectSession(RemoteFileSystemUserSession session) throws IOException {
        this.getApiSessionByAddress(session.getSocketAddress()).disconnect(1, "Disconnected");
    }

    private AbstractSession getApiSessionByAddress(InetSocketAddress address) {
        for (AbstractSession apiSession : this.api.getActiveSessions()) {
            InetSocketAddress apiSessionSocketAddress = (InetSocketAddress)apiSession.getRemoteAddress();
            if (!(apiSessionSocketAddress.getHostName() + ":" + apiSessionSocketAddress.getPort()).equals(address.getHostName() + ":" + address.getPort())) continue;
            return apiSession;
        }
        return null;
    }
}

