/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.file.hotlink;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.api.client.response.QueryResponse;
import com.gamedash.daemon.fileSystem.file.hotlink.Hotlink;
import com.gamedash.daemon.fileSystem.file.hotlink.HotlinkException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Hotlinks {
    private static List<Hotlink> hotlinks = new ArrayList<Hotlink>();

    public static List<Hotlink> getAll() {
        return hotlinks;
    }

    public static Hotlink get(String id) {
        for (Hotlink hotlink : Hotlinks.getAll()) {
            if (!hotlink.getId().equals(id)) continue;
            return hotlink;
        }
        return null;
    }

    public static boolean exists(String id) {
        for (Hotlink hotlink : Hotlinks.getAll()) {
            if (!hotlink.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static Hotlink create(String id, boolean isDirectory, File file) throws HotlinkException {
        if (Hotlinks.exists(id)) {
            throw new HotlinkException("Hotlink " + id + " already exists");
        }
        Hotlink hotlink = new Hotlink(id, isDirectory, file);
        hotlinks.add(hotlink);
        return hotlink;
    }

    public static void update() throws Exception {
        ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/filesystem/file/hotlink/all");
        QueryResponse queryResponse = query.get();
        for (JsonElement serializedHotlink : queryResponse.getJsonObject().get("response").getAsJsonArray()) {
            JsonObject serializedHotlinkObject = serializedHotlink.getAsJsonObject();
            if (!Hotlinks.exists(serializedHotlinkObject.get("id").getAsString())) {
                Hotlinks.create(serializedHotlinkObject.get("id").getAsString(), serializedHotlinkObject.get("isDirectory").getAsBoolean(), new File(serializedHotlinkObject.get("path").getAsString()));
                continue;
            }
            Hotlink hotlink = Hotlinks.get(serializedHotlinkObject.get("id").getAsString());
            hotlink.setIsDirectory(serializedHotlinkObject.get("isDirectory").getAsBoolean());
            hotlink.setFile(new File(serializedHotlinkObject.get("path").getAsString()));
        }
    }
}

